/*
 * Decompiled with CFR 0.152.
 */
package mx4j.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.util.Utils;

public class StandardMBeanProxy {
    public static Object create(Class mbeanInterface, ObjectName name) {
        return StandardMBeanProxy.create(mbeanInterface, null, name);
    }

    public static Object create(Class mbeanInterface, MBeanServer server, ObjectName name) {
        if (mbeanInterface == null) {
            throw new IllegalArgumentException("MBean interface cannot be null");
        }
        if (!mbeanInterface.isInterface()) {
            throw new IllegalArgumentException("Class parameter must be an interface");
        }
        if (name == null) {
            throw new IllegalArgumentException("MBean name cannot be null");
        }
        if (server == null) {
            ArrayList list = MBeanServerFactory.findMBeanServer(null);
            if (list.size() > 0) {
                server = (MBeanServer)list.get(0);
            } else {
                throw new IllegalStateException("Cannot find MBeanServer");
            }
        }
        ClassLoader loader = mbeanInterface.getClassLoader();
        return Proxy.newProxyInstance(loader, new Class[]{mbeanInterface}, (InvocationHandler)new Handler(server, name));
    }

    private static class Handler
    implements InvocationHandler {
        private MBeanServer m_server;
        private ObjectName m_name;

        private Handler(MBeanServer server, ObjectName name) {
            this.m_server = server;
            this.m_name = name;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null) {
                args = new Object[]{};
            }
            if (Utils.isAttributeSetter(method)) {
                String name = method.getName().substring(3);
                Attribute attribute = new Attribute(name, args[0]);
                try {
                    this.m_server.setAttribute(this.m_name, attribute);
                    return null;
                }
                catch (MBeanException x) {
                    throw x.getTargetException();
                }
                catch (ReflectionException x) {
                    throw x.getTargetException();
                }
                catch (RuntimeOperationsException x) {
                    throw x.getTargetException();
                }
                catch (RuntimeMBeanException x) {
                    throw x.getTargetException();
                }
                catch (RuntimeErrorException x) {
                    throw x.getTargetError();
                }
            }
            if (Utils.isAttributeGetter(method)) {
                String n = method.getName();
                String name = null;
                name = n.startsWith("is") ? n.substring(2) : n.substring(3);
                try {
                    return this.m_server.getAttribute(this.m_name, name);
                }
                catch (MBeanException x) {
                    throw x.getTargetException();
                }
                catch (ReflectionException x) {
                    throw x.getTargetException();
                }
                catch (RuntimeOperationsException x) {
                    throw x.getTargetException();
                }
                catch (RuntimeMBeanException x) {
                    throw x.getTargetException();
                }
                catch (RuntimeErrorException x) {
                    throw x.getTargetError();
                }
            }
            Class<?>[] parameters = method.getParameterTypes();
            String[] params = new String[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                params[i] = parameters[i].getName();
                ++i;
            }
            try {
                return this.m_server.invoke(this.m_name, method.getName(), args, params);
            }
            catch (MBeanException x) {
                throw x.getTargetException();
            }
            catch (ReflectionException x) {
                throw x.getTargetException();
            }
            catch (RuntimeOperationsException x) {
                throw x.getTargetException();
            }
            catch (RuntimeMBeanException x) {
                throw x.getTargetException();
            }
            catch (RuntimeErrorException x) {
                throw x.getTargetError();
            }
        }
    }
}

