/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.util.ArrayList;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.server.interceptor.InvokerMBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptorConfiguratorMBean;

public class MBeanServerInterceptorConfigurator
implements MBeanServerInterceptorConfiguratorMBean {
    private MBeanServer m_server;
    private MBeanServerInterceptor m_last;
    private MBeanServerInterceptor m_first;
    private ArrayList m_interceptors = new ArrayList();
    private boolean m_running;

    public MBeanServerInterceptorConfigurator(MBeanServer server) {
        this.m_server = server;
        this.m_last = new InvokerMBeanServerInterceptor(this.m_server);
    }

    public synchronized void addInterceptor(MBeanServerInterceptor interceptor) {
        if (!this.isRunning()) {
            this.m_interceptors.add(interceptor);
        }
    }

    public void registerInterceptor(MBeanServerInterceptor interceptor, ObjectName name) throws MBeanRegistrationException {
        if (!this.isRunning()) {
            try {
                this.m_server.registerMBean(interceptor, name);
                this.addInterceptor(interceptor);
            }
            catch (MBeanRegistrationException x) {
                throw x;
            }
            catch (Exception x) {
                throw new MBeanRegistrationException(x);
            }
        }
    }

    public synchronized MBeanServerInterceptor getHeadInterceptor() {
        return this.m_first;
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            if (this.m_interceptors.size() > 0) {
                int i = 1;
                while (i < this.m_interceptors.size()) {
                    MBeanServerInterceptor previous = (MBeanServerInterceptor)this.m_interceptors.get(i - 1);
                    MBeanServerInterceptor next = (MBeanServerInterceptor)this.m_interceptors.get(i);
                    previous.setNext(next);
                    ++i;
                }
                MBeanServerInterceptor interceptor = (MBeanServerInterceptor)this.m_interceptors.get(this.m_interceptors.size() - 1);
                interceptor.setNext(this.m_last);
                this.m_first = (MBeanServerInterceptor)this.m_interceptors.get(0);
            } else {
                this.m_first = this.m_last;
            }
            this.m_running = true;
            this.notifyAll();
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.m_first = null;
        }
    }

    public synchronized boolean isRunning() {
        return this.m_running;
    }

    public synchronized void clearInterceptors() {
        if (!this.isRunning()) {
            this.m_interceptors.clear();
        }
    }
}

