/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;
import javax.management.RuntimeOperationsException;
import mx4j.util.Utils;

public class MBeanAttributeInfo
extends MBeanFeatureInfo {
    private static final long serialVersionUID = 8644704819898565848L;
    private String attributeType;
    private boolean isRead;
    private boolean isWrite;
    private boolean is;

    public MBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description);
        if (getter == null && setter == null) {
            throw new IntrospectionException("Attribute must be readable or writable");
        }
        if (getter != null) {
            if (Utils.isAttributeGetter(getter)) {
                this.isRead = true;
                if (getter.getName().startsWith("is")) {
                    this.is = true;
                }
                this.attributeType = getter.getReturnType().getName();
            } else {
                throw new IntrospectionException("Bad getter method");
            }
        }
        if (setter != null) {
            if (Utils.isAttributeSetter(setter)) {
                this.isWrite = true;
                this.attributeType = setter.getParameterTypes()[0].getName();
            } else {
                throw new IntrospectionException("Bad setter method");
            }
        }
    }

    public MBeanAttributeInfo(String name, String className, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, description);
        if (!isReadable && !isWritable) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute must be readable or writable"));
        }
        this.attributeType = className == null ? "" : className;
        this.isRead = isReadable;
        this.isWrite = isWritable;
        this.is = isIs;
    }

    public String getType() {
        return this.attributeType;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public boolean isIs() {
        return this.is;
    }

    public int hashCode() {
        int hash = super.hashCode();
        String type = this.getType();
        hash ^= type == null ? 0 : type.hashCode();
        hash ^= this.isReadable() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        hash ^= this.isWritable() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        return hash ^= this.isIs() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        try {
            MBeanAttributeInfo other = (MBeanAttributeInfo)obj;
            String type = this.getType();
            String otherType = other.getType();
            if (type != null && !type.equals(otherType)) {
                return false;
            }
            if (type == null && otherType != null) {
                return false;
            }
            if (this.isReadable() ^ other.isReadable()) {
                return false;
            }
            if (this.isWritable() ^ other.isWritable()) {
                return false;
            }
            return !(this.isIs() ^ other.isIs());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

