/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.CallBag;
import com.mockobjects.dynamic.CallCollection;
import com.mockobjects.dynamic.Callable;
import com.mockobjects.dynamic.CallableAddable;
import com.mockobjects.dynamic.DynamicUtil;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.AssertionFailedError;

public class CallSequence
extends CallCollection
implements Callable,
CallableAddable {
    private ArrayList expectedCalls = new ArrayList();
    private CallBag matchedCalls = new CallBag();
    int callIndex = 0;

    public void reset() {
        this.expectedCalls.clear();
        this.matchedCalls.reset();
    }

    public Object call(Mock mock, String methodName, Object[] args) throws Throwable {
        Callable nextCall;
        if (this.expectedCalls.size() == 0) {
            throw new AssertionFailedError("no methods defined on mock, received: " + DynamicUtil.methodToString(methodName, args));
        }
        if (this.callIndex == this.expectedCalls.size()) {
            throw new AssertionFailedError("mock called too many times, received: " + DynamicUtil.methodToString(methodName, args));
        }
        if ((nextCall = (Callable)this.expectedCalls.get(this.callIndex++)).matches(methodName, args)) {
            return nextCall.call(mock, methodName, args);
        }
        try {
            return this.matchedCalls.call(mock, methodName, args);
        }
        catch (AssertionFailedError ex) {
            throw this.createUnexpectedCallError(methodName, args);
        }
    }

    public String getDescription() {
        if (this.expectedCalls.isEmpty()) {
            return "no methods";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("in sequence:\n");
        int j = 0;
        Iterator i = this.expectedCalls.iterator();
        while (i.hasNext()) {
            buf.append(((Callable)i.next()).getDescription());
            if (j++ == this.callIndex - 1) {
                buf.append(" <<< Next Expected Call");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean matches(String methodName, Object[] args) {
        throw new AssertionFailedError("matches() operation not supported in CallSequence");
    }

    public void addExpect(Callable call) {
        this.expectedCalls.add(call);
    }

    public void addMatch(Callable call) {
        this.matchedCalls.addMatch(call);
    }

    public void verify() {
        Iterator iter = this.expectedCalls.iterator();
        while (iter.hasNext()) {
            Callable callable = (Callable)iter.next();
            callable.verify();
        }
    }
}

