
package me.snowdrop.istio.client.internal.operation.networking.v1alpha3;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import me.snowdrop.istio.api.networking.v1alpha3.DestinationRule;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationRuleList;

import java.util.Map;
import java.util.TreeMap;


public class DestinationRuleOperationImpl extends HasMetadataOperation<DestinationRule, DestinationRuleList, Resource<DestinationRule>> {

  public DestinationRuleOperationImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public DestinationRuleOperationImpl(OperationContext context) {
    super(context.withApiGroupName("networking.istio.io")
      .withApiGroupVersion("v1alpha3")
      .withPlural("destinationrules"));
    this.type = DestinationRule.class;
    this.listType = DestinationRuleList.class;
}

  public DestinationRuleOperationImpl newInstance(OperationContext context) {
    return new DestinationRuleOperationImpl(context);
  }
}
