
package me.snowdrop.istio.client.internal.handler.policy.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.policy.v1beta1.InstanceOperationImpl;

import me.snowdrop.istio.api.policy.v1beta1.Instance;
import me.snowdrop.istio.api.policy.v1beta1.InstanceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class InstanceHandler implements ResourceHandler<Instance, InstanceBuilder> {

  @Override
  public String getKind() {
    return Instance.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.istio.io/v1alpha2";
    }

  @Override
public Instance create(OkHttpClient client, Config config, String namespace, Instance item) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public Instance replace(OkHttpClient client, Config config, String namespace, Instance item) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public Instance reload(OkHttpClient client, Config config, String namespace, Instance item) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public InstanceBuilder edit(Instance item) {
return new InstanceBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Instance item) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Instance item, Watcher<Instance> watcher) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Instance item, String resourceVersion, Watcher<Instance> watcher) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, Instance item, ListOptions listOptions, final Watcher<Instance> watcher) {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public Instance waitUntilReady(OkHttpClient client, Config config, String namespace, Instance item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public Instance waitUntilCondition(OkHttpClient client, Config config, String namespace, Instance item, Predicate<Instance> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new InstanceOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
