
package me.snowdrop.istio.client.internal.handler.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.networking.v1alpha3.DestinationRuleOperationImpl;

import me.snowdrop.istio.api.networking.v1alpha3.DestinationRule;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationRuleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class DestinationRuleHandler implements ResourceHandler<DestinationRule, DestinationRuleBuilder> {

  @Override
  public String getKind() {
    return DestinationRule.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "networking.istio.io/v1alpha3";
    }

  @Override
public DestinationRule create(OkHttpClient client, Config config, String namespace, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public DestinationRule replace(OkHttpClient client, Config config, String namespace, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public DestinationRule reload(OkHttpClient client, Config config, String namespace, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public DestinationRuleBuilder edit(DestinationRule item) {
return new DestinationRuleBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, DestinationRule item) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, DestinationRule item, Watcher<DestinationRule> watcher) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, DestinationRule item, String resourceVersion, Watcher<DestinationRule> watcher) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, DestinationRule item, ListOptions listOptions, final Watcher<DestinationRule> watcher) {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public DestinationRule waitUntilReady(OkHttpClient client, Config config, String namespace, DestinationRule item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public DestinationRule waitUntilCondition(OkHttpClient client, Config config, String namespace, DestinationRule item, Predicate<DestinationRule> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new DestinationRuleOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
