/*
 * Decompiled with CFR 0.152.
 */
package me.madhead.aws_junit5.common.impl;

import java.lang.reflect.Field;
import me.madhead.aws_junit5.common.AWSClient;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public abstract class AWSClientExtension
implements TestInstancePostProcessor {
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        for (Field field : testInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(AWSClient.class)) continue;
            this.inject(testInstance, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inject(Object testInstance, Field field) throws Exception {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            if (this.supports(field)) {
                field.set(testInstance, this.client(field));
            }
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected abstract boolean supports(Field var1);

    protected abstract Object client(Field var1) throws Exception;
}

