/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.maven.plugin.surefire.report.Node;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.TreePrinter;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;

public class TestReportHandler {
    protected static final Node node = Node.getRoot();
    protected static final Map<String, Set<String>> classNames = new ConcurrentHashMap<String, Set<String>>();
    protected static final Map<String, List<WrappedReportEntry>> classEntries = new ConcurrentHashMap<String, List<WrappedReportEntry>>();
    protected static final Map<String, List<WrappedReportEntry>> testEntries = new ConcurrentHashMap<String, List<WrappedReportEntry>>();
    protected static final int $ = 36;
    private final ReportEntry report;
    private final TestSetStats testSetStats;
    private final String sourceRootName;

    public TestReportHandler(ReportEntry report, TestSetStats testSetStats) {
        this.report = report;
        this.testSetStats = testSetStats;
        this.sourceRootName = this.getSourceRootName();
    }

    public TestReportHandler(ReportEntry report) {
        this(report, null);
    }

    public void prepare() {
        node.addNode(this.report);
        if (this.hasNestedTests()) {
            this.markClassNamesForNestedTests();
        }
    }

    public void print(TreePrinter treePrinter) {
        if (this.testSetStats != null) {
            this.testSetStats.getReportEntries().forEach(entry -> Node.getBranchNode((Node)TestReportHandler.node, this.getTestClassPath((String)entry.getSourceName())).get().wrappedReportEntries.add((WrappedReportEntry)entry));
        }
        Node classToBeTested = Node.getBranchNode(node, this.getTestClassPath(this.report.getSourceName())).get();
        classToBeTested.setClassReportEntry((WrappedReportEntry)this.report);
        if (this.isMarkedAsNestedTest()) {
            this.prepareEntriesForNestedTests();
            if (this.isNestedTestReadyToPrint()) {
                this.printNestedTests(treePrinter, classToBeTested);
            }
        } else {
            this.printTests(treePrinter, classToBeTested);
        }
    }

    List<String> getTestClassPath(String sourceName) {
        return Arrays.stream(sourceName.split("\\$", -1)).collect(Collectors.toList());
    }

    private boolean isMarkedAsNestedTest() {
        return classNames.containsKey(this.sourceRootName);
    }

    private void prepareClassEntriesForNestedTest() {
        classEntries.computeIfAbsent(this.sourceRootName, k -> new ArrayList()).add((WrappedReportEntry)this.report);
    }

    private List<WrappedReportEntry> getClassEntryList() {
        return classEntries.get(this.sourceRootName);
    }

    private void markClassNamesForNestedTests() {
        classNames.putIfAbsent(this.sourceRootName, new HashSet<String>(Collections.singleton(this.sourceRootName)));
        classNames.computeIfPresent(this.sourceRootName, this.addToCollection(this.report.getSourceName()));
    }

    private Set<String> getClassNameList() {
        return classNames.get(this.sourceRootName);
    }

    private void prepareTestEntriesForNestedTest() {
        testEntries.computeIfAbsent(this.sourceRootName, $ -> new ArrayList()).addAll(this.testSetStats.getReportEntries());
    }

    private List<WrappedReportEntry> getTestEntryList() {
        return testEntries.get(this.sourceRootName);
    }

    private void cleanEntries() {
        classNames.remove(this.sourceRootName);
        classEntries.remove(this.sourceRootName);
        testEntries.remove(this.sourceRootName);
    }

    private void prepareEntriesForNestedTests() {
        if (this.hasNestedTests()) {
            this.prepareTestEntriesForNestedTest();
        }
        this.prepareClassEntriesForNestedTest();
    }

    private boolean isNestedTestReadyToPrint() {
        return this.getClassEntryList().size() == this.getClassNameList().size();
    }

    private void printNestedTests(TreePrinter treePrinter, Node classToBeTested) {
        treePrinter.printTests(classToBeTested);
        this.cleanEntries();
    }

    private void printTests(TreePrinter treePrinter, Node classToBeTested) {
        treePrinter.printTests(classToBeTested);
    }

    private <J, K, V extends Collection<K>> BiFunction<J, V, V> addToCollection(K obj) {
        return (k, v) -> {
            v.add(obj);
            return v;
        };
    }

    private String getSourceRootName() {
        return this.report.getSourceName().split("\\$", -1)[0];
    }

    private boolean hasNestedTests() {
        if (this.testSetStats == null) {
            return this.hasNestedTests(this.report);
        }
        return this.hasNestedTests(this.testSetStats);
    }

    private boolean hasNestedTests(TestSetStats testSetStats) {
        return testSetStats.getReportEntries().stream().anyMatch(this::hasNestedTests);
    }

    private boolean hasNestedTests(ReportEntry reportEntry) {
        return reportEntry.getSourceName().chars().anyMatch(c -> c == 36);
    }
}

