/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.ReporterOptions;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.TextFormatter;
import org.apache.maven.plugin.surefire.report.Theme;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.shared.lang3.StringUtils;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class TreePrinter {
    private static final int $ = 36;
    private final ConsoleLogger consoleLogger;
    private final List<WrappedReportEntry> classResults;
    private final List<WrappedReportEntry> testSetStats;
    private final List<String> sourceNames;
    private final Set<String> distinctSourceName;
    private final ReporterOptions options;

    public TreePrinter(ConsoleLogger consoleLogger, List<WrappedReportEntry> classResults, List<WrappedReportEntry> testSetStats, ReporterOptions options) {
        this.consoleLogger = consoleLogger;
        this.classResults = classResults;
        this.testSetStats = testSetStats;
        this.sourceNames = this.getSourceNames();
        this.distinctSourceName = this.getDistinctSourceNames();
        this.options = options;
    }

    private List<String> getSourceNames() {
        return this.testSetStats.stream().map(WrappedReportEntry::getSourceName).collect(Collectors.toList());
    }

    private Set<String> getDistinctSourceNames() {
        return this.testSetStats.stream().map(WrappedReportEntry::getSourceName).collect(Collectors.toSet());
    }

    public void printTests() {
        this.testSetStats.stream().map(x$0 -> new TestPrinter((WrappedReportEntry)x$0)).forEach(printer -> {
            ((TestPrinter)printer).printTest(this.isSuccessPrintAllowed());
            ((TestPrinter)printer).printDetails();
        });
    }

    private boolean isSuccessPrintAllowed() {
        return !this.options.isHideResultsOnSuccess();
    }

    private class TestPrinter {
        private final WrappedReportEntry testResult;
        private final int treeLength;
        private final Theme theme;

        public TestPrinter(WrappedReportEntry testResult) {
            this.testResult = testResult;
            this.treeLength = this.getTreeLength();
            this.theme = TreePrinter.this.options.getTheme();
        }

        private void printDetails() {
            boolean printStdErr;
            boolean isSuccess = this.testResult.getReportEntryType() == ReportEntryType.SUCCESS;
            boolean isError = this.testResult.getReportEntryType() == ReportEntryType.ERROR;
            boolean isFailure = this.testResult.getReportEntryType() == ReportEntryType.FAILURE;
            boolean printStackTrace = TreePrinter.this.options.isPrintStacktraceOnError() && isError || TreePrinter.this.options.isPrintStacktraceOnFailure() && isFailure;
            boolean printStdOut = TreePrinter.this.options.isPrintStdoutOnSuccess() && isSuccess || TreePrinter.this.options.isPrintStdoutOnError() && isError || TreePrinter.this.options.isPrintStdoutOnFailure() && isFailure;
            boolean bl = printStdErr = TreePrinter.this.options.isPrintStderrOnSuccess() && isSuccess || TreePrinter.this.options.isPrintStderrOnError() && isError || TreePrinter.this.options.isPrintStderrOnFailure() && isFailure;
            if (printStackTrace || printStdOut || printStdErr) {
                this.printPreambleDetails();
                if (printStackTrace) {
                    this.printStackTrace();
                }
                if (printStdOut) {
                    this.printStdOut();
                }
                if (printStdErr) {
                    this.printStdErr();
                }
            }
        }

        private void printTest(boolean isPrintSuccessAllowed) {
            this.printClass();
            if (this.testResult.isErrorOrFailure()) {
                this.printFailure();
            } else if (this.testResult.isSkipped()) {
                this.printSkipped();
            } else if (isPrintSuccessAllowed && this.testResult.isSucceeded()) {
                this.printSuccess();
            }
        }

        private void printSuccess() {
            this.println(MessageUtils.buffer().success((Object)(this.theme.successful() + TextFormatter.abbreviateName(this.testResult.getReportName()))));
        }

        private void printSkipped() {
            this.println(MessageUtils.buffer().warning((Object)(this.theme.skipped() + this.getSkippedReport())).warning((Object)this.getSkippedMessage()));
        }

        private String getSkippedReport() {
            if (!org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)this.testResult.getReportName())) {
                return TextFormatter.abbreviateName(this.testResult.getReportName());
            }
            return this.testResult.getReportSourceName();
        }

        private String getSkippedMessage() {
            if (!org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)this.testResult.getMessage())) {
                return " (" + this.testResult.getMessage() + ")";
            }
            return "";
        }

        private void printPreambleDetails() {
            this.println("");
            if (this.testResult.isSucceeded()) {
                this.println(MessageUtils.buffer().success((Object)this.theme.details()).success((Object)TextFormatter.abbreviateName(this.testResult.getReportName())).toString());
            } else {
                this.println(MessageUtils.buffer().failure((Object)this.theme.details()).failure((Object)TextFormatter.abbreviateName(this.testResult.getReportName())).toString());
            }
        }

        private void printStdOut() {
            this.println("");
            this.println(MessageUtils.buffer().strong((Object)"Standard out").toString());
            try {
                this.testResult.getStdout().writeTo((OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void printStdErr() {
            this.println("");
            this.println(MessageUtils.buffer().strong((Object)"Standard error").toString());
            try {
                this.testResult.getStdErr().writeTo((OutputStream)System.err);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void printStackTrace() {
            this.println("");
            this.println(MessageUtils.buffer().strong((Object)"Stack trace").toString());
            String stackTrace = this.testResult.getStackTrace(false);
            if (stackTrace != null && !StringUtils.isBlank((CharSequence)stackTrace)) {
                this.println(this.testResult.getStackTrace(false));
            } else {
                this.println("[No stack trace available]");
            }
        }

        private void printFailure() {
            this.println(MessageUtils.buffer().failure((Object)(this.theme.failed() + TextFormatter.abbreviateName(this.testResult.getReportName()))));
        }

        private void printClass() {
            if (!TreePrinter.this.distinctSourceName.contains(this.testResult.getSourceName())) {
                return;
            }
            TreePrinter.this.distinctSourceName.remove(this.testResult.getSourceName());
            MessageBuilder builder = MessageUtils.buffer();
            if (this.treeLength > 0) {
                if (this.treeLength > 1) {
                    builder.a((CharSequence)this.theme.pipe());
                    LongStream.rangeClosed(0L, this.treeLength - 3).forEach(i -> builder.a((CharSequence)this.theme.blank()));
                    builder.a((CharSequence)this.theme.end());
                } else {
                    builder.a((CharSequence)this.theme.entry());
                }
                if (TreePrinter.this.sourceNames.stream().distinct().count() > 1L) {
                    builder.a((CharSequence)this.theme.down());
                } else {
                    builder.a((CharSequence)this.theme.dash());
                }
            } else {
                builder.a((CharSequence)this.theme.entry());
            }
            TestSetStats.concatenateWithTestGroup((MessageBuilder)builder, (ReportEntry)this.testResult, (!org.apache.maven.surefire.shared.utils.StringUtils.isBlank((String)this.testResult.getReportNameWithGroup()) ? 1 : 0) != 0);
            builder.a((CharSequence)(" - " + ((WrappedReportEntry)TreePrinter.this.classResults.get(this.treeLength)).elapsedTimeAsString()));
            this.println(builder.toString());
        }

        private MessageBuilder getTestPrefix() {
            MessageBuilder builder = MessageUtils.buffer().a((CharSequence)this.theme.pipe());
            if (this.treeLength > 0) {
                LongStream.rangeClosed(0L, this.treeLength - 2).forEach(i -> builder.a((CharSequence)this.theme.blank()));
                if (TreePrinter.this.sourceNames.stream().distinct().count() > 1L) {
                    builder.a((CharSequence)this.theme.pipe());
                } else {
                    builder.a((CharSequence)this.theme.blank());
                }
            }
            TreePrinter.this.sourceNames.remove(this.testResult.getSourceName());
            if (TreePrinter.this.sourceNames.contains(this.testResult.getSourceName())) {
                builder.a((CharSequence)this.theme.entry());
            } else {
                builder.a((CharSequence)this.theme.end());
            }
            return builder;
        }

        private int getTreeLength() {
            return (int)this.testResult.getSourceName().chars().filter(c -> c == 36).count();
        }

        private void println(MessageBuilder builder) {
            this.println(this.getTestPrefix().a((Object)builder).a((CharSequence)(" - " + this.testResult.elapsedTimeAsString())).toString());
        }

        private void println(String message) {
            TreePrinter.this.consoleLogger.info(message);
        }
    }
}

