/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Arrays;
import kg.apc.perfmon.metrics.AbstractMemMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

class MemTotalMetric
extends AbstractMemMetric {
    public static final byte ACTUAL_FREE = 0;
    public static final byte ACTUAL_USED = 1;
    public static final byte FREE = 2;
    public static final byte FREE_PERCENT = 3;
    public static final byte RAM = 4;
    public static final byte TOTAL = 5;
    public static final byte USED = 6;
    public static final byte USED_PERCENT = 7;
    public static final String[] types = new String[]{"actualfree", "actualused", "free", "freeperc", "ram", "total", "used", "usedperc"};
    private int type = -1;
    private int dividingFactor = 1;

    public MemTotalMetric(SigarProxy aSigar, MetricParamsSigar params) {
        super(aSigar, params);
        if (params.type.length() == 0) {
            this.type = 7;
        } else {
            this.type = Arrays.asList(types).indexOf(params.type);
            if (this.type < 0) {
                throw new IllegalArgumentException("Invalid total mem type: " + params.type);
            }
        }
        this.dividingFactor = this.getUnitDividingFactor(params.getUnit());
    }

    public void getValue(StringBuffer res) throws SigarException {
        Mem mem = this.sigarProxy.getMem();
        int factor = 1;
        switch (this.type) {
            case 0: {
                double val = mem.getActualFree();
                factor = this.dividingFactor;
                break;
            }
            case 1: {
                double val = mem.getActualUsed();
                factor = this.dividingFactor;
                break;
            }
            case 2: {
                double val = mem.getFree();
                factor = this.dividingFactor;
                break;
            }
            case 3: {
                double val = mem.getFreePercent();
                break;
            }
            case 4: {
                double val = mem.getRam();
                break;
            }
            case 5: {
                double val = mem.getTotal();
                factor = this.dividingFactor;
                break;
            }
            case 6: {
                double val = mem.getUsed();
                factor = this.dividingFactor;
                break;
            }
            case 7: {
                double val = mem.getUsedPercent();
                break;
            }
            default: {
                throw new SigarException("Unknown total mem type " + this.type);
            }
        }
        res.append(Double.toString(val /= (double)factor));
    }
}

