/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import kg.apc.perfmon.metrics.AbstractPerfMonMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

class DiskIOMetric
extends AbstractPerfMonMetric {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final byte AVAILABLE = 0;
    public static final byte DISK_QUEUE = 1;
    public static final byte READ_BYTES = 2;
    public static final byte READS = 3;
    public static final byte SERVICE_TIME = 4;
    public static final byte WRITE_BYTES = 5;
    public static final byte WRITES = 6;
    public static final byte FILES = 7;
    public static final byte FREE = 8;
    public static final byte FREE_FILES = 9;
    public static final byte TOTAL = 10;
    public static final byte USE_PERCENT = 11;
    public static final byte USED = 12;
    public static final String[] types = new String[]{"available", "queue", "readbytes", "reads", "service", "writebytes", "writes", "files", "free", "freefiles", "total", "useperc", "used"};
    private int type = -1;
    private final String[] filesystems;
    private double prev = -1.0;
    private int dividingFactor = 1;

    public DiskIOMetric(SigarProxy aSigar, MetricParamsSigar params) {
        super(aSigar);
        if (params.type.length() == 0) {
            this.type = 1;
        } else {
            this.type = Arrays.asList(types).indexOf(params.type);
            if (this.type < 0) {
                throw new IllegalArgumentException("Invalid disk io type: " + params.type);
            }
        }
        log.debug("Disk metric type: " + this.type);
        LinkedList<String> list = new LinkedList<String>();
        if (params.fs.length() != 0) {
            list.add(params.fs);
        } else {
            this.getAllDiskFilesystems(aSigar, list);
        }
        this.filesystems = list.toArray(new String[0]);
        this.dividingFactor = this.getUnitDividingFactor(params.getUnit());
    }

    private void getAllDiskFilesystems(SigarProxy aSigar, LinkedList list) {
        try {
            FileSystemMap map = aSigar.getFileSystemMap();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                FileSystem fs = (FileSystem)map.get(key);
                if (fs.getType() != 2) continue;
                list.add(key);
            }
        }
        catch (SigarException e) {
            log.warn("Can't get filesystems map", (Throwable)e);
        }
    }

    public static void logAvailableFilesystems(SigarProxy aSigar) {
        log.info("*** Logging available filesystems ***");
        try {
            FileSystemMap map = aSigar.getFileSystemMap();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                FileSystem fs = (FileSystem)map.get(key);
                log.info("Filesystem: fs=" + fs.toString() + " type=" + fs.getSysTypeName());
            }
        }
        catch (SigarException e) {
            log.warn("Can't get filesystems map", (Throwable)e);
        }
    }

    public void getValue(StringBuffer res) throws SigarException {
        double val = 0.0;
        long used = 0L;
        long total = 0L;
        int factor = 1;
        block23: for (int n = 0; n < this.filesystems.length; ++n) {
            FileSystemUsage usage = this.sigarProxy.getFileSystemUsage(this.filesystems[n]);
            switch (this.type) {
                case 0: {
                    val += (double)usage.getAvail();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 1: {
                    val += usage.getDiskQueue();
                    continue block23;
                }
                case 2: {
                    val += (double)usage.getDiskReadBytes();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 3: {
                    val += (double)usage.getDiskReads();
                    continue block23;
                }
                case 4: {
                    val += usage.getDiskServiceTime();
                    continue block23;
                }
                case 5: {
                    val += (double)usage.getDiskWriteBytes();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 6: {
                    val += (double)usage.getDiskWrites();
                    continue block23;
                }
                case 7: {
                    val += (double)usage.getFiles();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 8: {
                    val += (double)usage.getFree();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 9: {
                    val += (double)usage.getFreeFiles();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 10: {
                    val += (double)usage.getTotal();
                    factor = this.dividingFactor;
                    continue block23;
                }
                case 11: {
                    if (this.filesystems.length > 1) {
                        used += usage.getUsed();
                        total += usage.getTotal();
                        continue block23;
                    }
                    val += 100.0 * usage.getUsePercent();
                    continue block23;
                }
                case 12: {
                    val = usage.getUsed();
                    factor = this.dividingFactor;
                    continue block23;
                }
                default: {
                    throw new SigarException("Unknown disk I/O type " + this.type);
                }
            }
        }
        switch (this.type) {
            case 2: {
                double cur = val;
                val = this.prev > 0.0 ? cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 3: {
                double cur = val;
                val = this.prev > 0.0 ? cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 4: {
                double cur = val;
                break;
            }
            case 5: {
                double cur = val;
                val = this.prev > 0.0 ? cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 6: {
                double cur = val;
                val = this.prev > 0.0 ? cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 11: {
                if (this.filesystems.length <= 1) break;
                val = 100.0 * (double)used / (double)total;
            }
        }
        res.append(Double.toString(val /= (double)factor));
    }
}

