/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ListIterator;
import kg.apc.cmdtools.AbstractCMDTool;
import kg.apc.perfmon.PerfMonWorker;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class AgentTool
extends AbstractCMDTool {
    private static final Logger log = LoggingManager.getLoggerForClass();

    protected int processParams(ListIterator args) throws UnsupportedOperationException, IllegalArgumentException {
        PerfMonWorker worker;
        LoggingManager.setPriority((Priority)Priority.INFO);
        try {
            worker = this.getWorker();
        }
        catch (IOException ex) {
            log.error("Error", (Throwable)ex);
            return 0;
        }
        while (args.hasNext()) {
            String nextArg = (String)args.next();
            log.debug("Arg: " + nextArg);
            if (nextArg.equalsIgnoreCase("--tcp-port")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing TCP Port no");
                }
                worker.setTCPPort(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equals("--loglevel")) {
                args.remove();
                String loglevelStr = (String)args.next();
                LoggingManager.setPriority((String)loglevelStr);
                continue;
            }
            if (nextArg.equalsIgnoreCase("--interval")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing interval specification");
                }
                worker.setInterval(Long.parseLong((String)args.next()));
                continue;
            }
            if (nextArg.equalsIgnoreCase("--udp-port")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing UDP Port no");
                }
                worker.setUDPPort(Integer.parseInt((String)args.next()));
                continue;
            }
            if (nextArg.equals("--auto-shutdown")) {
                args.remove();
                worker.setAutoShutdown();
                continue;
            }
            if (nextArg.equals("--sysinfo")) {
                args.remove();
                worker.logSysInfo();
                continue;
            }
            if (nextArg.equals("--agent-version")) {
                args.remove();
                worker.logVersion();
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized option: " + nextArg);
        }
        try {
            worker.startAcceptingCommands();
            while (!worker.isFinished()) {
                worker.processCommands();
            }
        }
        catch (IOException e) {
            log.error("Error", (Throwable)e);
            return 0;
        }
        return worker.getExitCode();
    }

    protected void showHelp(PrintStream os) {
        os.println("Options for tool 'PerfMon': [ --tcp-port <port no> --udp-port <port no> --interval <seconds> --loglevel <debug|info|warn|error>--sysinfo --auto-shutdown]");
    }

    protected PerfMonWorker getWorker() throws IOException {
        return new PerfMonWorker();
    }
}

