/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.io.Serializable;
import kg.apc.charting.ColorsDispatcher;
import kg.apc.charting.colors.CustomPalette;
import kg.apc.charting.colors.CycleColors;
import kg.apc.charting.colors.HueRotatePalette;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ColorsDispatcherFactory
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static ColorsDispatcher getColorsDispatcher() {
        String customDispatcher = JMeterUtils.getProperty((String)"jmeterPlugin.customColorsDispatcher");
        String customOptions = JMeterUtils.getProperty((String)"jmeterPlugin.customColorsDispatcher.options");
        if (customDispatcher != null) {
            if (customDispatcher.equalsIgnoreCase("huerotate")) {
                log.debug("customDispatcher hue rotate");
                return new HueRotatePalette(customOptions);
            }
            if (customDispatcher.equalsIgnoreCase("custompalette")) {
                log.debug("customDispatcher custom palette");
                return new CustomPalette(customOptions);
            }
        }
        log.debug("Original boring cycle colors");
        return new CycleColors();
    }
}

