/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.charting.rows.GraphRowAverages;
import kg.apc.charting.rows.GraphRowOverallAverages;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractVsThreadVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class TimesVsThreadsGui
extends AbstractVsThreadVisualizer {
    public TimesVsThreadsGui() {
        this.graphPanel.getGraphObject().setYAxisLabel("Response times in ms");
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Response Times vs Threads");
    }

    @Override
    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        String label = res.getSampleLabel();
        String averageLabel = "Average " + res.getSampleLabel();
        String aggLabel = "Overall Response Times";
        String avgAggLabel = "Average " + aggLabel;
        GraphRowAverages row = (GraphRowAverages)this.model.get(label);
        GraphRowOverallAverages avgRow = (GraphRowOverallAverages)this.model.get(averageLabel);
        GraphRowAverages rowAgg = (GraphRowAverages)this.modelAggregate.get(aggLabel);
        GraphRowOverallAverages avgRowAgg = (GraphRowOverallAverages)this.modelAggregate.get(avgAggLabel);
        if (row == null || avgRow == null) {
            row = (GraphRowAverages)this.getNewRow(this.model, 0, label, 2, false, false, false, true, false);
            avgRow = (GraphRowOverallAverages)this.getNewRow(this.model, 2, averageLabel, 4, false, true, false, false, row.getColor(), false);
        }
        if (rowAgg == null || avgRowAgg == null) {
            rowAgg = (GraphRowAverages)this.getNewRow(this.modelAggregate, 0, aggLabel, 2, false, false, false, true, Color.RED, false);
            avgRowAgg = (GraphRowOverallAverages)this.getNewRow(this.modelAggregate, 2, avgAggLabel, 4, false, true, false, false, Color.RED, false);
        }
        int threadsCount = this.getCurrentThreadCount(res);
        row.add(threadsCount, res.getTime());
        avgRow.add(threadsCount, res.getTime());
        rowAgg.add(threadsCount, res.getTime());
        avgRowAgg.add(threadsCount, res.getTime());
        this.graphPanel.getGraphObject().setCurrentX(res.getAllThreads());
        this.updateGui(null);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 710);
    }

    @Override
    public String getWikiPage() {
        return "ResponseTimesVsThreads";
    }
}

