/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.control;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.control.ParameterizedController;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;

public class ParameterizedControllerGui
extends AbstractControllerGui {
    public static final String WIKIPAGE = "ParameterizedController";
    private ArgumentsPanel argsPanel;

    public ParameterizedControllerGui() {
        this.init();
    }

    public TestElement createTestElement() {
        ParameterizedController tc = new ParameterizedController();
        this.modifyTestElement((TestElement)tc);
        tc.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return tc;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        if (te instanceof ParameterizedController) {
            ParameterizedController controller = (ParameterizedController)te;
            controller.setUserDefinedVariables((Arguments)this.argsPanel.createTestElement());
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Parameterized Controller");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        this.add(this.createVariablePanel(), "Center");
    }

    private JPanel createVariablePanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"user_defined_variables"), null, true, true);
        return this.argsPanel;
    }

    public void clearGui() {
        super.clearGui();
        this.argsPanel.clear();
    }

    public void configure(TestElement te) {
        super.configure(te);
        ParameterizedController controller = (ParameterizedController)te;
        JMeterProperty udv = controller.getUserDefinedVariablesAsProperty();
        if (udv != null) {
            this.argsPanel.configure((TestElement)((Arguments)udv.getObjectValue()));
        }
    }
}

