/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.emulators;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kg.apc.emulators.EmulatorJmeterEngine;
import kg.apc.emulators.EmulatorThreadMonitor;
import kg.apc.jmeter.DirectoryAnchor;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;

public abstract class TestJMeterUtils {
    public static void createJmeterEnv() {
        JMeterUtils.setJMeterHome((String)TestJMeterUtils.getTempDir());
        File dst = new File(JMeterUtils.getJMeterHome() + "/ss.props");
        InputStream src = DirectoryAnchor.class.getResourceAsStream("/kg/apc/jmeter/bin/saveservice.properties");
        try {
            Files.copy(src, dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy file " + src + " to " + dst, e);
        }
        JMeterUtils.loadJMeterProperties((String)dst.getAbsolutePath());
        JMeterUtils.setLocale((Locale)new Locale("ignoreResources"));
        JMeterTreeModel jMeterTreeModel = new JMeterTreeModel();
        JMeterTreeListener jMeterTreeListener = new JMeterTreeListener();
        jMeterTreeListener.setModel(jMeterTreeModel);
        JMeterContextService.getContext().setVariables(new JMeterVariables());
        EmulatorJmeterEngine engine = new EmulatorJmeterEngine();
        EmulatorThreadMonitor monitor = new EmulatorThreadMonitor();
        JMeterContextService.getContext().setEngine((StandardJMeterEngine)engine);
        HashTree hashtree = new HashTree();
        hashtree.add((Object)new LoopController());
        JMeterThread thread = new JMeterThread(hashtree, (JMeterThreadMonitor)monitor, null);
        thread.setThreadName("test thread");
        JMeterContextService.getContext().setThread(thread);
        ThreadGroup threadGroup = new ThreadGroup();
        threadGroup.setName("test thread group");
        JMeterContextService.getContext().setThreadGroup((AbstractThreadGroup)threadGroup);
        JMeterUtils.setProperty((String)"sample_variables", (String)"TEST1,TEST2,TEST3");
        JMeterUtils.setProperty((String)"saveservice_properties", (String)"/ss.props");
        JMeterUtils.setProperty((String)"upgrade_properties", (String)"/ss.props");
    }

    public static String getTempDir() {
        Path f = null;
        try {
            File path = new File(System.getProperty("java.io.tmpdir") + "/jpgc");
            path.mkdirs();
            f = Files.createTempDirectory(path.toPath(), "ut", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get new temp dir", e);
        }
        assert (f != null);
        return f.toString();
    }

    public static String getTestData(int i) {
        return RandomStringUtils.randomAlphanumeric((int)i);
    }

    public static String fixWinPath(String path) {
        String ret = path;
        boolean isWinOs = System.getProperty("os.name").toLowerCase().contains("win");
        if (isWinOs) {
            ret = ret.replace("Documents%20and%20Settings", "DOCUME~1");
            ret = ret.replace("Local%20Settings", "LOCALS~1");
            ret = ret.replace("Application%20Data", "APPLIC~1");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

