/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.io.IOException;
import java.nio.ByteBuffer;
import kg.apc.jmeter.samplers.UDPTrafficDecoder;
import org.apache.jorphan.util.JOrphanUtils;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;

public class DNSJavaDecoder
implements UDPTrafficDecoder {
    public static final String NL = "\n";
    public static final String SPACE = " ";

    public ByteBuffer encode(String data) {
        return ByteBuffer.wrap(this.getMessageBytes(data));
    }

    protected byte[] getMessageBytes(String data) {
        String[] recs;
        Message msg = new Message();
        for (String rec : recs = data.split(NL)) {
            if (rec.length() <= 3) {
                Header head = msg.getHeader();
                int val = Integer.parseInt(rec.trim());
                if (val < 0) {
                    head.unsetFlag(-val);
                } else {
                    head.setFlag(val);
                }
                msg.setHeader(head);
                continue;
            }
            msg.addRecord(this.getRecord(rec.trim()), 0);
        }
        return msg.toWire();
    }

    protected Record getRecord(String recstr) {
        String[] fields = recstr.split(SPACE);
        if (fields.length != 3) {
            throw new IllegalArgumentException("Wrong DNS query string: " + recstr);
        }
        return Record.newRecord((Name)Name.fromConstantString((String)fields[0]), (int)Type.value((String)fields[1]), (int)DClass.value((String)fields[2]));
    }

    public byte[] decode(byte[] buf) {
        Message m;
        try {
            m = new Message(buf);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot decode DNS message: " + JOrphanUtils.baToHexString((byte[])buf), ex);
        }
        return m.toString().getBytes();
    }
}

