/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader;

import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import net.jini.security.Security;

public final class ClassLoading {
    private static final ThreadLocal perThreadCache = new ThreadLocal(){

        protected Object initialValue() {
            return new WeakHashMap();
        }
    };

    public static Class loadClass(String codebase, String name, ClassLoader defaultLoader, boolean verifyCodebaseIntegrity, ClassLoader verifierLoader) throws MalformedURLException, ClassNotFoundException {
        SecurityException verifyException = null;
        if (verifyCodebaseIntegrity && codebase != null) {
            try {
                ClassLoading.verifyIntegrity(codebase, verifierLoader);
            }
            catch (SecurityException e) {
                verifyException = e;
                codebase = null;
            }
        }
        try {
            return RMIClassLoader.loadClass(codebase, name, defaultLoader);
        }
        catch (ClassNotFoundException e) {
            if (verifyException != null) {
                throw new ClassNotFoundException(e.getMessage(), verifyException);
            }
            throw e;
        }
    }

    public static Class loadProxyClass(String codebase, String[] interfaceNames, ClassLoader defaultLoader, boolean verifyCodebaseIntegrity, ClassLoader verifierLoader) throws MalformedURLException, ClassNotFoundException {
        SecurityException verifyException = null;
        if (verifyCodebaseIntegrity && codebase != null) {
            try {
                ClassLoading.verifyIntegrity(codebase, verifierLoader);
            }
            catch (SecurityException e) {
                verifyException = e;
                codebase = null;
            }
        }
        try {
            return RMIClassLoader.loadProxyClass(codebase, interfaceNames, defaultLoader);
        }
        catch (ClassNotFoundException e) {
            if (verifyException != null) {
                throw new ClassNotFoundException(e.getMessage(), verifyException);
            }
            throw e;
        }
    }

    private static void verifyIntegrity(String codebase, ClassLoader verifierLoader) throws MalformedURLException {
        ClassLoader verifierLoaderKey;
        Map verifierLoaderCache = (Map)perThreadCache.get();
        WeakHashMap<String, SoftReference<String>> verifiedCodebases = (WeakHashMap<String, SoftReference<String>>)verifierLoaderCache.get(verifierLoaderKey = verifierLoader != null ? verifierLoader : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        }));
        if (verifiedCodebases != null && verifiedCodebases.containsKey(codebase)) {
            return;
        }
        Security.verifyCodebaseIntegrity(codebase, verifierLoader);
        if (verifiedCodebases == null) {
            verifiedCodebases = new WeakHashMap<String, SoftReference<String>>();
            verifierLoaderCache.put(verifierLoaderKey, verifiedCodebases);
        }
        verifiedCodebases.put(codebase, new SoftReference<String>(codebase));
    }

    private ClassLoading() {
        throw new AssertionError();
    }
}

