/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jrmp;

import java.lang.ref.WeakReference;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.Exporter;

public final class JrmpExporter
implements Exporter {
    private static final Logger logger = Logger.getLogger("net.jini.jrmp.JrmpExporter");
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final ActivationID id;
    private WeakReference ref;

    public JrmpExporter() {
        this(0);
    }

    public JrmpExporter(int port) {
        this(port, null, null);
    }

    public JrmpExporter(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        this.id = null;
    }

    public JrmpExporter(ActivationID id, int port) {
        this(id, port, null, null);
    }

    public JrmpExporter(ActivationID id, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
    }

    public int getPort() {
        return this.port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public ActivationID getActivationID() {
        return this.id;
    }

    public synchronized Remote export(Remote impl) throws ExportException {
        if (impl == null) {
            throw new NullPointerException();
        }
        if (this.ref != null) {
            throw new IllegalStateException("object already exported via this exporter");
        }
        this.ref = new WeakReference<Remote>(impl);
        try {
            Remote proxy;
            Remote remote = proxy = this.id != null ? Activatable.exportObject((Remote)impl, (ActivationID)this.id, (int)this.port, (RMIClientSocketFactory)this.csf, (RMIServerSocketFactory)this.ssf) : UnicastRemoteObject.exportObject(impl, this.port, this.csf, this.ssf);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "export of {0} via {1} returns proxy {2}", new Object[]{impl, this, proxy});
            }
            return proxy;
        }
        catch (ExportException ex) {
            throw ex;
        }
        catch (RemoteException ex) {
            throw new ExportException("export failed", ex);
        }
    }

    public synchronized boolean unexport(boolean force) {
        if (this.ref == null) {
            throw new IllegalStateException("an object has not been exported via this exporter");
        }
        Remote impl = (Remote)this.ref.get();
        if (impl == null) {
            return true;
        }
        try {
            boolean result;
            boolean bl = result = this.id != null ? Activatable.unexportObject((Remote)impl, (boolean)force) : UnicastRemoteObject.unexportObject(impl, force);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "unexport on {0} returns {1}", new Object[]{this, result});
            }
            return result;
        }
        catch (NoSuchObjectException ex) {
            return true;
        }
    }

    public String toString() {
        return this.id != null ? "JrmpExporter[" + this.id + "," + this.port + "," + this.csf + "," + this.ssf + "]" : "JrmpExporter[" + this.port + "," + this.csf + "," + this.ssf + "]";
    }
}

