/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.BasicExportTable;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;

public final class BasicJeriExporter
implements Exporter {
    private static final Logger logger;
    private final ServerEndpoint se;
    private final InvocationLayerFactory ilf;
    private final boolean enableDGC;
    private final boolean keepAlive;
    private final Uuid id;
    private boolean used = false;
    private BasicExportTable.Entry entry;
    private WeakReference weakImplContainer = null;
    private static final BasicExportTable table;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicJeriExporter(ServerEndpoint se, InvocationLayerFactory ilf) {
        this(se, ilf, false, true);
    }

    public BasicJeriExporter(ServerEndpoint se, InvocationLayerFactory ilf, boolean enableDGC, boolean keepAlive) {
        this(se, ilf, enableDGC, keepAlive, null);
    }

    public BasicJeriExporter(ServerEndpoint se, InvocationLayerFactory ilf, boolean enableDGC, boolean keepAlive, Uuid id) {
        if (se == null || ilf == null) {
            throw new NullPointerException();
        }
        this.se = se;
        this.ilf = ilf;
        this.id = id == null ? UuidFactory.generate() : id;
        this.enableDGC = enableDGC;
        this.keepAlive = keepAlive;
    }

    public ServerEndpoint getServerEndpoint() {
        return this.se;
    }

    public InvocationLayerFactory getInvocationLayerFactory() {
        return this.ilf;
    }

    public boolean getEnableDGC() {
        return this.enableDGC;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Uuid getObjectIdentifier() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized Remote export(Remote impl) throws ExportException {
        void var2_5;
        if (this.used) {
            throw new IllegalStateException("object already exported via this exporter");
        }
        if (!$assertionsDisabled && this.entry != null) {
            throw new AssertionError();
        }
        this.entry = table.export(impl, this.se, this.enableDGC, this.keepAlive, this.id);
        this.used = true;
        InvocationLayerFactory.Instances inst = null;
        try {
            ImplContainer implContainer = new ImplContainer(impl);
            this.weakImplContainer = new WeakReference<ImplContainer>(implContainer);
            BasicObjectEndpoint oe = new BasicObjectEndpoint(this.entry.getEndpoint(), this.id, this.enableDGC, implContainer);
            inst = this.ilf.createInstances(impl, oe, this.se);
            this.entry.setInvocationDispatcher(inst.getInvocationDispatcher());
            Remote proxy = inst.getProxy();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "export of {0} via {1} returns proxy {2}", new Object[]{impl, this, proxy});
            }
        }
        finally {
            if (inst == null) {
                this.unexport(true);
            }
        }
        return var2_5;
    }

    public synchronized boolean unexport(boolean force) {
        boolean result;
        if (!this.used) {
            throw new IllegalStateException("no object exported via this exporter");
        }
        if (this.entry != null && this.entry.unexport(force)) {
            this.entry = null;
            ImplContainer implContainer = (ImplContainer)this.weakImplContainer.get();
            if (implContainer != null) {
                implContainer.clearImpl();
            }
        }
        boolean bl = result = this.entry == null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "unexport on {0} returns {1}", new Object[]{this, result});
        }
        return result;
    }

    public String toString() {
        return "BasicJeriExporter[" + this.se + "," + this.id + "]";
    }

    static {
        $assertionsDisabled = !BasicJeriExporter.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
        table = new BasicExportTable();
    }

    private static class ImplContainer {
        private Object impl;

        ImplContainer(Object impl) {
            this.impl = impl;
        }

        void clearImpl() {
            this.impl = null;
        }
    }
}

