/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.internal.BaseProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

class EndpointBasedProvider
extends BaseProvider {
    protected final EndpointInternals endpointInternals;

    EndpointBasedProvider(String formatName, EndpointInternals endpointInternals) {
        super(formatName);
        if (endpointInternals == null) {
            throw new NullPointerException();
        }
        this.endpointInternals = endpointInternals;
    }

    static boolean checkIntegrity(InvocationConstraints constraints) throws UnsupportedConstraintException {
        boolean integrity = false;
        Iterator i = constraints.requirements().iterator();
        while (i.hasNext()) {
            InvocationConstraint c = (InvocationConstraint)i.next();
            if (c == Integrity.YES) {
                integrity = true;
                continue;
            }
            if (c instanceof Integrity) continue;
            throw new UnsupportedConstraintException("cannot satisfy constraint: " + c);
        }
        if (!integrity) {
            i = constraints.preferences().iterator();
            while (i.hasNext()) {
                if (i.next() != Integrity.YES) continue;
                integrity = true;
                break;
            }
        }
        return integrity;
    }

    static byte[] calcHandshakeHash(ByteBuffer request, ByteBuffer response) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            EndpointBasedProvider.update(md, request);
            EndpointBasedProvider.update(md, response);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void update(MessageDigest md, ByteBuffer buf) {
        if (buf.hasArray()) {
            md.update(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            buf.position(buf.limit());
        } else {
            byte[] b = new byte[buf.remaining()];
            buf.get(b);
            md.update(b, 0, b.length);
        }
    }
}

