/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.LogicalAddress1_4;

public class LogicalAddressTest
extends TestCase {
    LogicalAddress1_4 a;
    LogicalAddress1_4 b;
    LogicalAddress1_4 c;
    static /* synthetic */ Class class$org$jgroups$tests$LogicalAddressTest;

    public LogicalAddressTest(String name) {
        super(name);
    }

    public void setUp() throws CloneNotSupportedException {
        this.a = new LogicalAddress1_4("host1", null);
        this.b = new LogicalAddress1_4("host1", null);
        this.c = (LogicalAddress1_4)this.a.clone();
    }

    public void tearDown() {
    }

    public void testEquality() throws Exception {
        LogicalAddressTest.assertFalse((boolean)this.a.equals(this.b));
        LogicalAddressTest.assertFalse((boolean)this.c.equals(this.b));
        LogicalAddressTest.assertTrue((boolean)this.a.equals(this.c));
        LogicalAddressTest.assertTrue((boolean)this.c.equals(this.a));
    }

    public void testMcast() {
        LogicalAddressTest.assertFalse((boolean)this.a.isMulticastAddress());
    }

    public void testCompareTo() {
        LogicalAddressTest.assertTrue((this.a.compareTo(this.c) == 0 ? 1 : 0) != 0);
        LogicalAddressTest.assertTrue((this.a.compareTo(this.b) < 0 ? 1 : 0) != 0);
        LogicalAddressTest.assertTrue((this.b.compareTo(this.a) > 0 ? 1 : 0) != 0);
    }

    public void testExternalization() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        this.a.setAdditionalData(null);
        this.b.setAdditionalData("Bela Ban".getBytes());
        oos.writeObject(this.a);
        oos.writeObject(this.b);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        LogicalAddress1_4 a2 = (LogicalAddress1_4)ois.readObject();
        LogicalAddress1_4 b2 = (LogicalAddress1_4)ois.readObject();
        LogicalAddressTest.assertTrue((boolean)this.a.equals(a2));
        LogicalAddressTest.assertTrue((boolean)this.b.equals(b2));
        LogicalAddressTest.assertTrue((a2.getAdditionalData() == null ? 1 : 0) != 0);
        LogicalAddressTest.assertTrue((boolean)"Bela Ban".equals(new String(b2.getAdditionalData())));
    }

    public void testExternalizationAdditionalData() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        byte[] buf = null;
        ByteArrayInputStream bis = null;
        oos.writeObject(this.a);
        oos.writeObject(this.b);
        oos.writeObject(this.c);
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        LogicalAddress1_4 a2 = (LogicalAddress1_4)ois.readObject();
        LogicalAddress1_4 b2 = (LogicalAddress1_4)ois.readObject();
        LogicalAddress1_4 c2 = (LogicalAddress1_4)ois.readObject();
        LogicalAddressTest.assertTrue((boolean)this.a.equals(a2));
        LogicalAddressTest.assertTrue((boolean)this.b.equals(b2));
        LogicalAddressTest.assertTrue((boolean)this.c.equals(c2));
        LogicalAddressTest.assertTrue((boolean)c2.equals(a2));
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$LogicalAddressTest == null ? (class$org$jgroups$tests$LogicalAddressTest = LogicalAddressTest.class$("org.jgroups.tests.LogicalAddressTest")) : class$org$jgroups$tests$LogicalAddressTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LogicalAddressTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

