/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.protocols.AUTOCONF;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.List;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class UDP
extends Protocol
implements Runnable {
    DatagramSocket sock = null;
    MulticastSocket mcast_recv_sock = null;
    MulticastSocket mcast_send_sock = null;
    IpAddress local_addr = null;
    String group_addr = null;
    IpAddress mcast_addr = null;
    InetAddress bind_addr = null;
    int bind_port = 0;
    int port_range = 1;
    String mcast_addr_name = "228.8.8.8";
    int mcast_port = 7600;
    Thread mcast_receiver = null;
    UcastReceiver ucast_receiver = null;
    boolean ip_mcast = true;
    int ip_ttl = 64;
    Vector members = new Vector(11);
    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);
    int mcast_send_buf_size = 32000;
    int mcast_recv_buf_size = 64000;
    int ucast_send_buf_size = 32000;
    int ucast_recv_buf_size = 64000;
    boolean loopback = true;
    boolean discard_incompatible_packets = false;
    boolean use_incoming_packet_handler = false;
    Queue incoming_queue = null;
    IncomingPacketHandler incoming_packet_handler = null;
    boolean use_outgoing_packet_handler = false;
    Queue outgoing_queue = null;
    OutgoingPacketHandler outgoing_packet_handler = null;
    byte[] additional_data = null;
    int max_bundle_size = AUTOCONF.senseMaxFragSizeStatic();
    long max_bundle_timeout = 20L;
    boolean enable_bundling = false;
    TimeScheduler timer = null;
    final String name = "UDP";
    final int VERSION_LENGTH = Version.getLength();

    public String toString() {
        return "Protocol UDP(local address: " + this.local_addr + ')';
    }

    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_receiver != null && this.mcast_recv_sock != null) {
            try {
                packet.setData(receive_buf, 0, receive_buf.length);
                this.mcast_recv_sock.receive(packet);
                int len = packet.getLength();
                byte[] data = packet.getData();
                if (len == 1 && data[0] == 0) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)"received dummy packet");
                    continue;
                }
                if (len == 4 && data[0] == 100 && data[1] == 105 && data[2] == 97 && data[3] == 103) {
                    this.handleDiagnosticProbe(packet.getAddress(), packet.getPort());
                    continue;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("received (mcast) " + packet.getLength() + " bytes from " + packet.getAddress() + ':' + packet.getPort() + " (size=" + len + " bytes)"));
                }
                if (len > receive_buf.length && this.log.isErrorEnabled()) {
                    this.log.error((Object)("size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length));
                }
                if (!Version.compareTo(data)) {
                    if (this.log.isWarnEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("packet from ").append(packet.getAddress()).append(':').append(packet.getPort());
                        sb.append(" has different version (").append(Version.printVersionId(data, Version.version_id.length));
                        sb.append(") from ours (").append(Version.printVersionId(Version.version_id)).append("). ");
                        if (this.discard_incompatible_packets) {
                            sb.append("Packet is discarded");
                        } else {
                            sb.append("This may cause problems");
                        }
                        this.log.warn((Object)sb.toString());
                    }
                    if (this.discard_incompatible_packets) continue;
                }
                if (this.use_incoming_packet_handler) {
                    byte[] tmp = new byte[len];
                    System.arraycopy(data, 0, tmp, 0, len);
                    this.incoming_queue.add(tmp);
                    continue;
                }
                this.handleIncomingUdpPacket(data);
            }
            catch (SocketException sock_ex) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("multicast socket is closed, exception=" + sock_ex));
                break;
            }
            catch (InterruptedIOException io_ex) {
            }
            catch (Throwable ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("exception=" + ex + ", stack trace=" + Util.printStackTrace(ex)));
                }
                Util.sleep(300L);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"multicast thread terminated");
        }
    }

    void handleDiagnosticProbe(InetAddress sender, int port) {
        block3: {
            try {
                byte[] diag_rsp = this.getDiagResponse().getBytes();
                DatagramPacket rsp = new DatagramPacket(diag_rsp, 0, diag_rsp.length, sender, port);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sending diag response to " + sender + ':' + port));
                }
                this.sock.send(rsp);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)("failed sending diag rsp to " + sender + ':' + port + ", exception=" + t));
            }
        }
    }

    String getDiagResponse() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.group_addr).append(')');
        sb.append(" [").append(this.mcast_addr_name).append(':').append(this.mcast_port).append("]\n");
        sb.append("Version=").append(Version.version).append(", cvs=\"").append(Version.cvs).append("\"\n");
        sb.append("bound to ").append(this.bind_addr).append(':').append(this.bind_port).append('\n');
        sb.append("members: ").append(this.members).append('\n');
        return sb.toString();
    }

    public String getName() {
        return "UDP";
    }

    public void init() throws Exception {
        if (this.use_incoming_packet_handler) {
            this.incoming_queue = new Queue();
            this.incoming_packet_handler = new IncomingPacketHandler();
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_queue = new Queue();
            if (this.enable_bundling) {
                TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
                if (this.timer == null) {
                    throw new Exception("UDP.init(): timer could not be retrieved");
                }
                this.outgoing_packet_handler = new BundlingOutgoingPacketHandler();
            } else {
                this.outgoing_packet_handler = new OutgoingPacketHandler();
            }
        }
    }

    public void start() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"creating sockets and starting threads");
        }
        this.createSockets();
        this.passUp(new Event(8, this.local_addr));
        this.startThreads();
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"closing sockets and stopping threads");
        }
        this.stopThreads();
        this.closeSockets();
    }

    public boolean setProperties(Properties props) {
        String tmp = null;
        super.setProperties(props);
        try {
            tmp = System.getProperty("bind.address");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String str = tmp != null ? tmp : props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("bind_port");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("mcast_addr")) != null) {
            this.mcast_addr_name = str;
            props.remove("mcast_addr");
        }
        if ((str = props.getProperty("mcast_port")) != null) {
            this.mcast_port = Integer.parseInt(str);
            props.remove("mcast_port");
        }
        if ((str = props.getProperty("ip_mcast")) != null) {
            this.ip_mcast = Boolean.valueOf(str);
            props.remove("ip_mcast");
        }
        if ((str = props.getProperty("ip_ttl")) != null) {
            this.ip_ttl = Integer.parseInt(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("mcast_send_buf_size")) != null) {
            this.mcast_send_buf_size = Integer.parseInt(str);
            props.remove("mcast_send_buf_size");
        }
        if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
            this.mcast_recv_buf_size = Integer.parseInt(str);
            props.remove("mcast_recv_buf_size");
        }
        if ((str = props.getProperty("ucast_send_buf_size")) != null) {
            this.ucast_send_buf_size = Integer.parseInt(str);
            props.remove("ucast_send_buf_size");
        }
        if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
            this.ucast_recv_buf_size = Integer.parseInt(str);
            props.remove("ucast_recv_buf_size");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("discard_incompatibe_packets")) != null) {
            this.discard_incompatible_packets = Boolean.valueOf(str);
            props.remove("discard_incompatibe_packets");
        }
        if ((str = props.getProperty("use_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_packet_handler");
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"'use_packet_handler' is deprecated; use 'use_incoming_packet_handler' instead");
            }
        }
        if ((str = props.getProperty("use_incoming_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_incoming_packet_handler");
        }
        if ((str = props.getProperty("use_outgoing_packet_handler")) != null) {
            this.use_outgoing_packet_handler = Boolean.valueOf(str);
            props.remove("use_outgoing_packet_handler");
        }
        if ((str = props.getProperty("max_bundle_size")) != null) {
            int bundle_size = Integer.parseInt(str);
            if (bundle_size > this.max_bundle_size) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is greater than largest UDP fragmentation size (" + this.max_bundle_size + ')'));
                }
                return false;
            }
            if (bundle_size <= 0) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is <= 0"));
                }
                return false;
            }
            this.max_bundle_size = bundle_size;
            props.remove("max_bundle_size");
        }
        if ((str = props.getProperty("max_bundle_timeout")) != null) {
            this.max_bundle_timeout = Long.parseLong(str);
            if (this.max_bundle_timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_timeout of " + this.max_bundle_timeout + " is invalid"));
                }
                return false;
            }
            props.remove("max_bundle_timeout");
        }
        if ((str = props.getProperty("enable_bundling")) != null) {
            this.enable_bundling = Boolean.valueOf(str);
            props.remove("enable_bundling");
        }
        if (props.size() > 0) {
            System.err.println("UDP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        if (this.enable_bundling) {
            if (!this.use_outgoing_packet_handler && this.log.isWarnEnabled()) {
                this.log.warn((Object)"enable_bundling is true; setting use_outgoing_packet_handler=true");
            }
            this.use_outgoing_packet_handler = true;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        block10: {
            if (evt.getType() != 1) {
                this.handleDownEvent(evt);
                return;
            }
            Message msg = (Message)evt.getArg();
            if (this.group_addr != null) {
                msg.putHeader("UDP", new UdpHeader(this.group_addr));
            }
            Address dest_addr = msg.getDest();
            if (this.observer != null) {
                this.observer.passDown(evt);
            }
            if (dest_addr == null) {
                if (this.ip_mcast) {
                    if (this.mcast_addr == null) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("dest address of message is null, and sending to default address fails as mcast_addr is null, too ! Discarding message " + Util.printEvent(evt)));
                        }
                        return;
                    }
                    msg.setDest(this.mcast_addr);
                } else {
                    this.sendMultipleUdpMessages(msg, this.members);
                    return;
                }
            }
            try {
                this.sendUdpMessage(msg);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block10;
                this.log.error((Object)("exception=" + e + ", msg=" + msg + ", mcast_addr=" + this.mcast_addr));
            }
        }
    }

    void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    void handleIncomingUdpPacket(byte[] data) {
        block7: {
            Message msg = null;
            try {
                ByteArrayInputStream inp_stream = new ByteArrayInputStream(data, this.VERSION_LENGTH, data.length - this.VERSION_LENGTH);
                ObjectInputStream inp = new ObjectInputStream(inp_stream);
                if (this.enable_bundling) {
                    List l = new List();
                    l.readExternal(inp);
                    Enumeration en = l.elements();
                    while (en.hasMoreElements()) {
                        msg = (Message)en.nextElement();
                        try {
                            this.handleMessage(msg);
                        }
                        catch (Throwable t) {
                            if (!this.log.isErrorEnabled()) continue;
                            this.log.error((Object)("failure: " + t.toString()));
                        }
                    }
                } else {
                    msg = new Message();
                    msg.readExternal(inp);
                    this.handleMessage(msg);
                }
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)("exception=" + Util.getStackTrace(e)));
            }
        }
    }

    void handleMessage(Message msg) {
        UdpHeader hdr;
        if (this.loopback) {
            Address dst = msg.getDest();
            Address src = msg.getSrc();
            if (dst != null && dst.isMulticastAddress() && src != null && this.local_addr.equals(src)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"discarded own loopback multicast packet");
                }
                return;
            }
        }
        Event evt = new Event(1, msg);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("message is " + msg + ", headers are " + msg.getHeaders()));
        }
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if ((hdr = (UdpHeader)msg.getHeader("UDP")) != null) {
            String ch_name = null;
            if (hdr.group_addr != null) {
                ch_name = hdr.group_addr;
            }
            if (ch_name != null && this.group_addr != null && !this.group_addr.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc()));
                }
                return;
            }
        } else if (this.log.isErrorEnabled()) {
            this.log.error((Object)"message does not have a UDP header");
        }
        this.passUp(evt);
    }

    void sendUdpMessage(Message msg) throws Exception {
        IpAddress dest = (IpAddress)msg.getDest();
        this.setSourceAddress(msg);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("sending message to " + msg.getDest() + " (src=" + msg.getSrc() + "), headers are " + msg.getHeaders()));
        }
        if (this.loopback && (dest.equals(this.local_addr) || dest.isMulticastAddress())) {
            Message copy = msg.copy();
            copy.setSrc(this.local_addr);
            copy.setDest(dest);
            Event evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("looped back local message " + copy));
            }
            this.passUp(evt);
            if (!dest.isMulticastAddress()) {
                return;
            }
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_queue.add(msg);
            return;
        }
        this.send(msg);
    }

    void send(Message msg) throws Exception {
        IpAddress dest = (IpAddress)msg.getDest();
        byte[] buf = this.messageToBuffer(msg);
        this.doSend(buf, dest.getIpAddress(), dest.getPort());
    }

    void doSend(byte[] data, InetAddress dest, int port) throws IOException {
        DatagramPacket packet = new DatagramPacket(data, data.length, dest, port);
        if (dest.isMulticastAddress() && this.mcast_send_sock != null) {
            this.mcast_send_sock.send(packet);
        } else if (this.sock != null) {
            this.sock.send(packet);
        }
    }

    void sendMultipleUdpMessages(Message msg, Vector dests) {
        for (int i = 0; i < dests.size(); ++i) {
            Address dest = (Address)dests.elementAt(i);
            msg.setDest(dest);
            try {
                this.sendUdpMessage(msg);
                continue;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("exception=" + e));
            }
        }
    }

    byte[] messageToBuffer(Message msg) throws Exception {
        this.out_stream.reset();
        this.out_stream.write(Version.version_id, 0, Version.version_id.length);
        ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
        msg.writeExternal(out);
        out.flush();
        return this.out_stream.toByteArray();
    }

    void createSockets() throws Exception {
        InetAddress[] interfaces;
        InetAddress tmp_addr = null;
        if (this.bind_addr == null && (interfaces = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress())) != null && interfaces.length > 0) {
            this.bind_addr = interfaces[0];
        }
        if (this.bind_addr == null) {
            this.bind_addr = InetAddress.getLocalHost();
        }
        if (this.bind_addr != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("unicast sockets will use interface " + this.bind_addr.getHostAddress()));
        }
        int rcv_port = this.bind_port;
        int max_port = this.bind_port + this.port_range;
        while (rcv_port <= max_port) {
            try {
                this.sock = new DatagramSocket(rcv_port, this.bind_addr);
                break;
            }
            catch (SocketException bind_ex) {
                ++rcv_port;
            }
            catch (SecurityException sec_ex) {
                ++rcv_port;
            }
            if (rcv_port != max_port + 1) continue;
            throw new Exception("UDP.createSockets(): cannot list on any port in range " + this.bind_port + '-' + (this.bind_port + this.port_range));
        }
        if (this.sock == null) {
            throw new Exception("UDP.createSocket(): sock is null");
        }
        this.local_addr = new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
        if (this.additional_data != null) {
            this.local_addr.setAdditionalData(this.additional_data);
        }
        if (this.ip_mcast) {
            this.mcast_recv_sock = new MulticastSocket(this.mcast_port);
            this.mcast_recv_sock.setTimeToLive(this.ip_ttl);
            if (this.bind_addr != null) {
                this.mcast_recv_sock.setInterface(this.bind_addr);
            }
            tmp_addr = InetAddress.getByName(this.mcast_addr_name);
            this.mcast_addr = new IpAddress(tmp_addr, this.mcast_port);
            this.mcast_recv_sock.joinGroup(tmp_addr);
            this.mcast_send_sock = new MulticastSocket();
            this.mcast_send_sock.setTimeToLive(this.ip_ttl);
            if (this.bind_addr != null) {
                this.mcast_send_sock.setInterface(this.bind_addr);
            }
        }
        this.setBufferSizes();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("socket information:\n" + this.dumpSocketInfo()));
        }
    }

    String dumpSocketInfo() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr);
        sb.append(", mcast_addr=").append(this.mcast_addr);
        sb.append(", bind_addr=").append(this.bind_addr);
        sb.append(", ttl=").append(this.ip_ttl);
        if (this.sock != null) {
            sb.append("\nsock: bound to ");
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(", receive buffer size=").append(this.sock.getReceiveBufferSize());
            sb.append(", send buffer size=").append(this.sock.getSendBufferSize());
        }
        if (this.mcast_recv_sock != null) {
            sb.append("\nmcast_recv_sock: bound to ");
            sb.append(this.mcast_recv_sock.getInterface().getHostAddress()).append(':').append(this.mcast_recv_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_recv_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_recv_sock.getReceiveBufferSize());
        }
        if (this.mcast_send_sock != null) {
            sb.append("\nmcast_send_sock: bound to ");
            sb.append(this.mcast_send_sock.getInterface().getHostAddress()).append(':').append(this.mcast_send_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_send_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_send_sock.getReceiveBufferSize());
        }
        return sb.toString();
    }

    void setBufferSizes() {
        block20: {
            block18: {
                block16: {
                    if (this.sock != null) {
                        block15: {
                            try {
                                this.sock.setSendBufferSize(this.ucast_send_buf_size);
                            }
                            catch (Throwable ex) {
                                if (!this.log.isWarnEnabled()) break block15;
                                this.log.warn((Object)("failed setting ucast_send_buf_size in sock: " + ex));
                            }
                        }
                        try {
                            this.sock.setReceiveBufferSize(this.ucast_recv_buf_size);
                        }
                        catch (Throwable ex) {
                            if (!this.log.isWarnEnabled()) break block16;
                            this.log.warn((Object)("failed setting ucast_recv_buf_size in sock: " + ex));
                        }
                    }
                }
                if (this.mcast_recv_sock != null) {
                    block17: {
                        try {
                            this.mcast_recv_sock.setSendBufferSize(this.mcast_send_buf_size);
                        }
                        catch (Throwable ex) {
                            if (!this.log.isWarnEnabled()) break block17;
                            this.log.warn((Object)("failed setting mcast_send_buf_size in mcast_recv_sock: " + ex));
                        }
                    }
                    try {
                        this.mcast_recv_sock.setReceiveBufferSize(this.mcast_recv_buf_size);
                    }
                    catch (Throwable ex) {
                        if (!this.log.isWarnEnabled()) break block18;
                        this.log.warn((Object)("failed setting mcast_recv_buf_size in mcast_recv_sock: " + ex));
                    }
                }
            }
            if (this.mcast_send_sock != null) {
                block19: {
                    try {
                        this.mcast_send_sock.setSendBufferSize(this.mcast_send_buf_size);
                    }
                    catch (Throwable ex) {
                        if (!this.log.isWarnEnabled()) break block19;
                        this.log.warn((Object)("failed setting mcast_send_buf_size in mcast_send_sock: " + ex));
                    }
                }
                try {
                    this.mcast_send_sock.setReceiveBufferSize(this.mcast_recv_buf_size);
                }
                catch (Throwable ex) {
                    if (!this.log.isWarnEnabled()) break block20;
                    this.log.warn((Object)("failed setting mcast_recv_buf_size in mcast_send_sock: " + ex));
                }
            }
        }
    }

    void closeSockets() {
        this.closeMulticastSocket();
        this.closeSocket();
    }

    void closeMulticastSocket() {
        if (this.mcast_recv_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.sendDummyPacket(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort());
                    Util.sleep(300L);
                    this.mcast_recv_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.mcast_recv_sock.close();
                this.mcast_recv_sock = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"multicast receive socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
        if (this.mcast_send_sock != null) {
            this.mcast_send_sock.close();
            this.mcast_send_sock = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"multicast send socket closed");
            }
        }
    }

    void closeSocket() {
        if (this.sock != null) {
            this.sendDummyPacket(this.sock.getLocalAddress(), this.sock.getLocalPort());
            this.sock.close();
            this.sock = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"socket closed");
            }
        }
    }

    void sendDummyPacket(InetAddress dest, int port) {
        block8: {
            byte[] buf = new byte[]{0};
            if (dest == null) {
                try {
                    dest = InetAddress.getLocalHost();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("sending packet to " + dest + ':' + port));
            }
            if (this.sock == null || dest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"sock was null or dest was null, cannot send dummy packet");
                }
                return;
            }
            DatagramPacket packet = new DatagramPacket(buf, buf.length, dest, port);
            try {
                this.sock.send(packet);
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error((Object)("exception sending dummy packet to " + dest + ':' + port + ": " + e));
            }
        }
    }

    void startThreads() throws Exception {
        if (this.ucast_receiver == null) {
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"created unicast receiver thread");
            }
        }
        if (this.ip_mcast) {
            if (this.mcast_receiver != null) {
                if (this.mcast_receiver.isAlive()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"did not create new multicastreceiver thread as existing multicast receiver thread is still running");
                    }
                } else {
                    this.mcast_receiver = null;
                }
            }
            if (this.mcast_receiver == null) {
                this.mcast_receiver = new Thread((Runnable)this, "UDP mcast receiver");
                this.mcast_receiver.setPriority(10);
                this.mcast_receiver.setDaemon(true);
                this.mcast_receiver.start();
            }
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_packet_handler.start();
        }
        if (this.use_incoming_packet_handler) {
            this.incoming_packet_handler.start();
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            if (this.mcast_receiver.isAlive()) {
                Thread tmp = this.mcast_receiver;
                this.mcast_receiver = null;
                this.closeMulticastSocket();
                tmp.interrupt();
                try {
                    tmp.join(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object var1_1 = null;
            }
            this.mcast_receiver = null;
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
            this.ucast_receiver = null;
        }
        if (this.incoming_packet_handler != null) {
            this.incoming_packet_handler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
        }
        this.setBufferSizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dumpMessages(HashMap map) {
        StringBuffer sb = new StringBuffer();
        if (map != null) {
            HashMap hashMap = map;
            synchronized (hashMap) {
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    List l = (List)entry.getValue();
                    sb.append(entry.getKey()).append(": ");
                    sb.append(l.size()).append(" msgs\n");
                }
            }
        }
        return sb.toString();
    }

    class BundlingOutgoingPacketHandler
    extends OutgoingPacketHandler {
        long total_bytes = 0L;
        boolean timer_running = false;
        HashMap msgs = new HashMap(11);
        MyTask task = new MyTask();

        BundlingOutgoingPacketHandler() {
        }

        void startTimer() {
            if (!this.timer_running) {
                this.timer_running = true;
                UDP.this.timer.add(this.task);
            }
        }

        void stopTimer() {
            this.timer_running = false;
        }

        void stop() {
            this.stopTimer();
            super.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleMessage(Message msg) throws Exception {
            Address dest = msg.getDest();
            long len = msg.size();
            if (len > (long)UDP.this.max_bundle_size) {
                throw new Exception("UDP.BundlingOutgoingPacketHandler.handleMessage(): message size (" + len + ") is greater than UDP fragmentation size. " + "Set the fragmentation/bundle size in FRAG and UDP correctly");
            }
            if (this.total_bytes + len >= (long)UDP.this.max_bundle_size) {
                if (UDP.this.log.isTraceEnabled()) {
                    UDP.this.log.trace((Object)("sending " + this.total_bytes + " bytes"));
                }
                this.bundleAndSend();
                this.total_bytes = 0L;
            }
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                List tmp = (List)this.msgs.get(dest);
                if (tmp == null) {
                    tmp = new List();
                    this.msgs.put(dest, tmp);
                }
                tmp.add(msg);
                this.total_bytes += len;
            }
            if (!this.timer_running) {
                this.startTimer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bundleAndSend() {
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug((Object)("\nsending msgs:\n" + UDP.this.dumpMessages(this.msgs)));
            }
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                this.stopTimer();
                if (this.msgs.size() == 0) {
                    return;
                }
                Iterator it = this.msgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    IpAddress dest = (IpAddress)entry.getKey();
                    InetAddress addr = dest.getIpAddress();
                    int port = dest.getPort();
                    List l = (List)entry.getValue();
                    try {
                        UDP.this.out_stream.reset();
                        UDP.this.out_stream.write(Version.version_id, 0, Version.version_id.length);
                        ObjectOutputStream out = new ObjectOutputStream(UDP.this.out_stream);
                        l.writeExternal(out);
                        out.close();
                        byte[] data = UDP.this.out_stream.toByteArray();
                        UDP.this.doSend(data, addr, port);
                    }
                    catch (IOException e) {
                        if (!UDP.this.log.isErrorEnabled()) continue;
                        UDP.this.log.error((Object)("exception sending msg (to dest=" + dest + "): " + e));
                    }
                }
                this.msgs.clear();
            }
        }

        class MyTask
        implements TimeScheduler.Task {
            MyTask() {
            }

            public boolean cancelled() {
                return !BundlingOutgoingPacketHandler.this.timer_running;
            }

            public long nextInterval() {
                return ((BundlingOutgoingPacketHandler)BundlingOutgoingPacketHandler.this).UDP.this.max_bundle_timeout;
            }

            public void run() {
                if (BundlingOutgoingPacketHandler.this.timer_running) {
                    BundlingOutgoingPacketHandler.this.bundleAndSend();
                }
            }
        }
    }

    class OutgoingPacketHandler
    implements Runnable {
        Thread t = null;
        ObjectOutputStream out;
        byte[] buf;
        DatagramPacket packet;
        IpAddress dest;

        OutgoingPacketHandler() {
        }

        public void run() {
            while (UDP.this.outgoing_queue != null && UDP.this.outgoing_packet_handler != null) {
                Message msg;
                block4: {
                    try {
                        msg = (Message)UDP.this.outgoing_queue.remove();
                        this.handleMessage(msg);
                    }
                    catch (QueueClosedException closed_ex) {
                        if (!UDP.this.log.isDebugEnabled()) break;
                        UDP.this.log.debug((Object)"packet_handler thread terminating");
                        break;
                    }
                    catch (Throwable th) {
                        if (!UDP.this.log.isErrorEnabled()) break block4;
                        UDP.this.log.error((Object)("exception sending packet: " + Util.printStackTrace(th)));
                    }
                }
                msg = null;
            }
        }

        protected void handleMessage(Message msg) throws Exception {
            UDP.this.send(msg);
        }

        void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "UDP.OutgoingPacketHandler thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (UDP.this.outgoing_queue != null) {
                UDP.this.outgoing_queue.close(false);
            }
            this.t = null;
            UDP.this.outgoing_queue = null;
        }
    }

    class IncomingPacketHandler
    implements Runnable {
        Thread t = null;

        IncomingPacketHandler() {
        }

        public void run() {
            while (UDP.this.incoming_queue != null && UDP.this.incoming_packet_handler != null) {
                byte[] data;
                try {
                    data = (byte[])UDP.this.incoming_queue.remove();
                }
                catch (QueueClosedException closed_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug((Object)"packet_handler thread terminating");
                    break;
                }
                UDP.this.handleIncomingUdpPacket(data);
                data = null;
            }
        }

        void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "UDP.IncomingPacketHandler thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (UDP.this.incoming_queue != null) {
                UDP.this.incoming_queue.close(false);
            }
            this.t = null;
            UDP.this.incoming_queue = null;
        }
    }

    public class UcastReceiver
    implements Runnable {
        boolean running = true;
        Thread thread = null;

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "UDP.UcastReceiverThread");
                this.thread.setDaemon(true);
                this.running = true;
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.running = false;
                Thread tmp = this.thread;
                this.thread = null;
                UDP.this.closeSocket();
                tmp.interrupt();
                Object var1_1 = null;
            }
            this.thread = null;
        }

        public void run() {
            byte[] receive_buf = new byte[65535];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.running && this.thread != null && UDP.this.sock != null) {
                try {
                    packet.setData(receive_buf, 0, receive_buf.length);
                    UDP.this.sock.receive(packet);
                    int len = packet.getLength();
                    byte[] data = packet.getData();
                    if (len == 1 && data[0] == 0) {
                        if (!UDP.this.log.isTraceEnabled()) continue;
                        UDP.this.log.trace((Object)"received dummy packet");
                        continue;
                    }
                    if (UDP.this.log.isTraceEnabled()) {
                        UDP.this.log.trace((Object)("received (ucast) " + len + " bytes from " + packet.getAddress() + ':' + packet.getPort()));
                    }
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error((Object)("size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length));
                    }
                    if (!Version.compareTo(data) && UDP.this.log.isWarnEnabled()) {
                        UDP.this.log.warn((Object)("packet from " + packet.getAddress() + ':' + packet.getPort() + " has different version (" + Version.printVersionId(data, Version.version_id.length) + ") from ours (" + Version.printVersionId(Version.version_id) + "). This may cause problems"));
                    }
                    if (UDP.this.use_incoming_packet_handler) {
                        byte[] tmp = new byte[len];
                        System.arraycopy(data, 0, tmp, 0, len);
                        UDP.this.incoming_queue.add(tmp);
                        continue;
                    }
                    UDP.this.handleIncomingUdpPacket(data);
                }
                catch (SocketException sock_ex) {
                    if (!UDP.this.log.isDebugEnabled()) break;
                    UDP.this.log.debug((Object)("unicast receiver socket is closed, exception=" + sock_ex));
                    break;
                }
                catch (InterruptedIOException io_ex) {
                }
                catch (Throwable ex) {
                    if (UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error((Object)("[" + UDP.this.local_addr + "] exception=" + ex + ", stack trace=" + Util.printStackTrace(ex)));
                    }
                    Util.sleep(300L);
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug((Object)"unicast receiver thread terminated");
            }
        }
    }
}

