/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.List;
import org.jgroups.util.Util;

public class PING
extends Protocol {
    Vector members = new Vector(11);
    Vector initial_members = new Vector(11);
    Set members_set = new HashSet(11);
    Address local_addr = null;
    String group_addr = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    String gossip_host = null;
    int gossip_port = 0;
    long gossip_refresh = 20000L;
    GossipClient client;
    boolean is_server = false;
    int port_range = 1;
    List initial_hosts = null;

    public String getName() {
        return "PING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>(1);
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            if (this.timeout <= 0L && this.log.isErrorEnabled()) {
                this.log.error((Object)"timeout must be > 0");
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = Integer.parseInt(str);
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("gossip_host")) != null) {
            this.gossip_host = str;
            props.remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = Integer.parseInt(str);
            props.remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = Long.parseLong(str);
            props.remove("gossip_refresh");
        }
        if (this.gossip_host != null && this.gossip_port != 0) {
            try {
                this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("creation of GossipClient failed, exception=" + e));
                }
                return false;
            }
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("The following properties are not recognized: " + sb));
            }
            return false;
        }
        return true;
    }

    public void stop() {
        this.is_server = false;
        if (this.client != null) {
            this.client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        PingRsp ping_rsp = new PingRsp(this.local_addr, coord);
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, ping_rsp);
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("received GET_MBRS_REQ from " + msg.getSrc() + ", returning " + rsp_hdr));
                        }
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("received FIND_INITAL_MBRS_RSP, rsp=" + rsp));
                            }
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("got PING header with unknown type (" + hdr.type + ')'));
                }
                return;
            }
            case 8: {
                List hlist;
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                if (this.initial_hosts == null || this.local_addr == null) break;
                boolean inInitialHosts = false;
                Enumeration en = this.initial_hosts.elements();
                while (en.hasMoreElements() && !inInitialHosts) {
                    hlist = (List)en.nextElement();
                    if (!hlist.contains(this.local_addr)) continue;
                    inInitialHosts = true;
                }
                if (inInitialHosts) break;
                hlist = new List();
                hlist.add(this.local_addr);
                this.initial_hosts.add(hlist);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("[SET_LOCAL_ADDRESS]: adding my own address (" + this.local_addr + ") to initial_hosts; initial_hosts=" + this.initial_hosts));
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        Vector gossip_rsps = null;
        switch (evt.getType()) {
            case 12: {
                Cloneable h;
                Message msg;
                this.initial_members.removeAllElements();
                if (this.client != null) {
                    gossip_rsps = this.client.getMembers(this.group_addr);
                    if (gossip_rsps == null || gossip_rsps.size() <= 0) {
                        this.passUp(new Event(13, null));
                        return;
                    }
                    Event view_event = new Event(15, this.makeView(gossip_rsps));
                    this.passDown(view_event);
                    if (gossip_rsps != null && gossip_rsps.size() > 0) {
                        for (int i = 0; i < gossip_rsps.size(); ++i) {
                            Address dest = (Address)gossip_rsps.elementAt(i);
                            msg = new Message(dest, null, null);
                            msg.putHeader(this.getName(), new PingHeader(1, null));
                            this.passDown(new Event(1, msg));
                        }
                    }
                    Util.sleep(500L);
                } else if (this.initial_hosts != null && this.initial_hosts.size() > 0) {
                    msg = new Message(null, null, null);
                    msg.putHeader(this.getName(), new PingHeader(1, null));
                    Vector vector = this.members;
                    synchronized (vector) {
                        int numMembers = this.members.size();
                        int numMemberInitialHosts = 0;
                        Address coord = numMembers > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        Enumeration en = this.initial_hosts.elements();
                        while (en.hasMoreElements()) {
                            List hlist = (List)en.nextElement();
                            boolean isMember = false;
                            Enumeration hen = hlist.elements();
                            while (hen.hasMoreElements() && !isMember && numMemberInitialHosts < numMembers) {
                                h = (IpAddress)hen.nextElement();
                                if (!this.members_set.contains(h)) continue;
                                this.initial_members.add(new PingRsp((Address)h, coord));
                                isMember = true;
                                ++numMemberInitialHosts;
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug((Object)("[FIND_INITIAL_MBRS] " + h + " is already a member"));
                            }
                            hen = hlist.elements();
                            while (hen.hasMoreElements() && !isMember) {
                                h = (IpAddress)hen.nextElement();
                                msg.setDest((Address)h);
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
                                }
                                this.passDown(new Event(1, msg.copy()));
                            }
                        }
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"FIND_INITIAL_MBRS");
                    }
                    PingHeader hdr = new PingHeader(1, null);
                    msg = new Message(null, null, null);
                    msg.putHeader(this.getName(), hdr);
                    this.passDown(new Event(1, msg));
                }
                h = this.initial_members;
                synchronized (h) {
                    long start_time = System.currentTimeMillis();
                    for (long time_to_wait = this.timeout; (long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L; time_to_wait -= System.currentTimeMillis() - start_time) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("waiting for initial members: time_to_wait=" + time_to_wait + ", got " + this.initial_members.size() + " rsps"));
                        }
                        try {
                            this.initial_members.wait(time_to_wait);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("initial mbrs are " + this.initial_members));
                }
                this.passUp(new Event(13, this.initial_members));
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.clear();
                        this.members.addAll(tmp);
                        this.members_set.clear();
                        this.members_set.addAll(tmp);
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                if (this.client == null) break;
                this.client.register(this.group_addr, this.local_addr);
                break;
            }
            case 4: {
                if (this.client != null) {
                    this.client.stop();
                }
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        ViewId view_id = new ViewId(this.local_addr);
        coord = view_id.getCoordAddress();
        id = view_id.getId();
        return new View(coord, id, mbrs);
    }

    private List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                List hosts = new List();
                for (int i = port; i < port + this.port_range; ++i) {
                    hosts.add(new IpAddress(host, i));
                }
                tmp.add(hosts);
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return tmp;
    }
}

