/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class KeyStoreGenerator {
    static String symAlg = "Blowfish";
    static int keySize = 56;
    static String keyStoreName = "defaultStore.keystore";
    static String storePass = "changeit";
    static String alias = "myKey";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i = 0;
        String arg = null;
        boolean specified = false;
        while (i < args.length && args[i].startsWith("-")) {
            if ((arg = args[i++]).equalsIgnoreCase("--alg")) {
                if (i < args.length) {
                    symAlg = args[i++];
                    continue;
                }
                System.out.println("No Algorithm supplied using default of " + symAlg);
                continue;
            }
            if (arg.equalsIgnoreCase("--size")) {
                if (i < args.length) {
                    keySize = Integer.parseInt(args[i++]);
                    continue;
                }
                System.out.println("No Size supplied using default of " + keySize);
                continue;
            }
            if (arg.equalsIgnoreCase("--storeName")) {
                if (i < args.length) {
                    keyStoreName = args[i++];
                    continue;
                }
                System.out.println("No Size supplied using default of " + keyStoreName);
                continue;
            }
            if (arg.equalsIgnoreCase("--storePass")) {
                if (i < args.length) {
                    storePass = args[i++];
                    continue;
                }
                System.out.println("No password supplied using default of " + storePass);
                continue;
            }
            if (!arg.equalsIgnoreCase("--alias")) continue;
            if (i < args.length) {
                alias = args[i++];
                continue;
            }
            System.out.println("No alias supplied using default of " + alias);
        }
        System.out.println("Creating file '" + keyStoreName + "' using Algorithm '" + symAlg + "' size '" + keySize + "'");
        FileOutputStream stream2 = null;
        try {
            stream2 = new FileOutputStream(keyStoreName);
            SecretKey key = KeyStoreGenerator.initSymKey();
            KeyStore store = KeyStore.getInstance("JCEKS");
            store.load(null, null);
            store.setKeyEntry(alias, key, storePass.toCharArray(), null);
            store.store(stream2, storePass.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((OutputStream)stream2).close();
            }
            catch (Exception e) {}
        }
        System.out.println("Finished keystore creation");
    }

    public static SecretKey initSymKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = KeyGenerator.getInstance(KeyStoreGenerator.getAlgorithm(symAlg));
        keyGen.init(keySize);
        SecretKey secretKey = keyGen.generateKey();
        return secretKey;
    }

    private static String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }
}

