/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.jung;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.io.PajekNetWriter;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;

public class JungAdapter
implements DirectedGraph<Integer, Long> {
    private final ImmutableGraph graph;
    private final ImmutableGraph transpose;
    private final int n;

    public JungAdapter(ImmutableGraph graph, ImmutableGraph transpose) {
        this.graph = graph;
        this.transpose = transpose;
        this.n = graph.numNodes();
        if (graph.numArcs() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
    }

    public Integer getSource(Long e) {
        return (int)(e >>> 32);
    }

    public Integer getDest(Long e) {
        return e.intValue();
    }

    public Pair<Integer> getEndpoints(Long e) {
        return new Pair((Object)this.getSource(e), (Object)this.getDest(e));
    }

    public Collection<Long> getInEdges(Integer x) {
        long p;
        int v = x;
        ObjectArrayList list = new ObjectArrayList(this.transpose.outdegree(v));
        LazyIntIterator pred = this.transpose.successors(v);
        while ((p = (long)pred.nextInt()) != -1L) {
            list.add((Object)(p << 32 | (long)v));
        }
        return list;
    }

    public Integer getOpposite(Integer v, Long e) {
        int x = e.intValue();
        if (x != v) {
            return x;
        }
        return this.getSource(e);
    }

    public Collection<Long> getOutEdges(Integer x) {
        int s;
        int v = x;
        ObjectArrayList list = new ObjectArrayList(this.graph.outdegree(v));
        LazyIntIterator succ = this.graph.successors(v);
        long nodeShifted = (long)v << 32;
        while ((s = succ.nextInt()) != -1) {
            list.add((Object)(nodeShifted | (long)s));
        }
        return list;
    }

    public int getPredecessorCount(Integer x) {
        return this.transpose.outdegree(x);
    }

    private static Collection<Integer> getSuccessors(ImmutableGraph g, int x) {
        int s;
        ObjectArrayList list = new ObjectArrayList(g.outdegree(x));
        LazyIntIterator succ = g.successors(x);
        while ((s = succ.nextInt()) != -1) {
            list.add((Object)s);
        }
        return list;
    }

    public Collection<Integer> getPredecessors(Integer x) {
        return JungAdapter.getSuccessors(this.transpose, x);
    }

    public int getSuccessorCount(Integer x) {
        return this.graph.outdegree(x);
    }

    public Collection<Integer> getSuccessors(Integer x) {
        return JungAdapter.getSuccessors(this.graph, x);
    }

    public int inDegree(Integer x) {
        return this.getPredecessorCount(x);
    }

    public boolean isDest(Integer v, Long e) {
        return e.intValue() == v.intValue();
    }

    public boolean isArc(int x, int y) {
        int s;
        LazyIntIterator succ = this.graph.successors(x);
        while ((s = succ.nextInt()) != -1) {
            if (s != y) continue;
            return true;
        }
        return false;
    }

    public boolean isPredecessor(Integer x, Integer y) {
        return this.isArc(x, y);
    }

    public boolean isSource(Integer v, Long e) {
        return e >>> 32 == (long)v.intValue();
    }

    public boolean isSuccessor(Integer x, Integer y) {
        return this.isArc(y, x);
    }

    public int outDegree(Integer x) {
        return this.graph.outdegree(x);
    }

    public boolean containsEdge(Long e) {
        return this.isArc((int)(e >>> 32), e.intValue());
    }

    public boolean containsVertex(Integer x) {
        int v = x;
        return v >= 0 && v < this.n;
    }

    public int degree(Integer x) {
        int s;
        int v = x;
        int self = 0;
        LazyIntIterator succ = this.graph.successors(v);
        while ((s = succ.nextInt()) != -1) {
            if (s != v) continue;
            ++self;
        }
        return this.graph.outdegree(v) + (this.transpose.outdegree(v) - self);
    }

    public Long findEdge(Integer x, Integer y) {
        if (!this.containsVertex(x) || !this.containsVertex(y)) {
            return null;
        }
        Long l = x.longValue() << 32 | (long)y.intValue();
        return this.containsEdge(l) ? l : null;
    }

    public Collection<Long> findEdgeSet(Integer x, Integer y) {
        Long e = x.longValue() << 32 | (long)y.intValue();
        return this.containsEdge(e) ? ObjectLists.singleton((Object)e) : ObjectLists.emptyList();
    }

    public EdgeType getDefaultEdgeType() {
        return EdgeType.DIRECTED;
    }

    public int getEdgeCount() {
        return (int)this.graph.numArcs();
    }

    public int getEdgeCount(EdgeType x) {
        return EdgeType.DIRECTED.equals((Object)x) ? this.getEdgeCount() : 0;
    }

    public EdgeType getEdgeType(Long e) {
        return EdgeType.DIRECTED;
    }

    public Collection<Long> getEdges() {
        ObjectArrayList edges = new ObjectArrayList();
        NodeIterator iterator = this.graph.nodeIterator();
        int i = this.n;
        while (i-- != 0) {
            int x = iterator.nextInt();
            long xShifted = (long)x << 32;
            int d = iterator.outdegree();
            int[] s = iterator.successorArray();
            for (int j = 0; j < d; ++j) {
                edges.add((Object)(xShifted | (long)s[j]));
            }
        }
        return edges;
    }

    public Collection<Long> getEdges(EdgeType x) {
        return EdgeType.DIRECTED.equals((Object)x) ? this.getEdges() : ObjectLists.emptyList();
    }

    public int getIncidentCount(Long e) {
        return (long)e.intValue() != e >>> 32 ? 2 : 1;
    }

    public Collection<Long> getIncidentEdges(Integer x) {
        int p;
        int s;
        int v = x;
        long vShifted = (long)v << 32;
        int outdegree = this.graph.outdegree(v);
        int indegree = this.transpose.outdegree(v);
        LazyIntIterator succ = this.graph.successors(v);
        LazyIntIterator pred = this.transpose.successors(v);
        ObjectArrayList res = new ObjectArrayList(outdegree + indegree);
        while ((s = succ.nextInt()) != -1) {
            res.add((Object)(vShifted | (long)s));
        }
        while ((p = pred.nextInt()) != -1) {
            if (p == v) continue;
            res.add((Object)((long)p << 32 | (long)v));
        }
        return res;
    }

    public Collection<Integer> getIncidentVertices(Long e) {
        int y;
        int x = (int)(e >>> 32);
        if (x == (y = e.intValue())) {
            return ObjectLists.singleton((Object)x);
        }
        ObjectArrayList res = new ObjectArrayList();
        res.add((Object)x);
        res.add((Object)y);
        return res;
    }

    public int getNeighborCount(Integer x) {
        return this.getNeighbors(x).size();
    }

    public Collection<Integer> getNeighbors(Integer x) {
        int p;
        int s;
        int v = x;
        int outdegree = this.graph.outdegree(v);
        int indegree = this.transpose.outdegree(v);
        LazyIntIterator succ = this.graph.successors(v);
        LazyIntIterator pred = this.transpose.successors(v);
        ObjectOpenHashSet res = new ObjectOpenHashSet(outdegree + indegree);
        while ((s = succ.nextInt()) != -1) {
            res.add((Object)s);
        }
        while ((p = pred.nextInt()) != -1) {
            res.add((Object)p);
        }
        return res;
    }

    public int getVertexCount() {
        return this.n;
    }

    public Collection<Integer> getVertices() {
        return new AbstractObjectList<Integer>(){

            public Integer get(int x) {
                return x;
            }

            public int size() {
                return JungAdapter.this.n;
            }
        };
    }

    public boolean isIncident(Integer x, Long e) {
        int v = x;
        return e.intValue() == v || e >>> 32 == (long)v;
    }

    public boolean isNeighbor(Integer x, Integer y) {
        int p;
        int s;
        int v = x;
        int w = y;
        LazyIntIterator succ = this.graph.successors(v);
        while ((s = succ.nextInt()) != -1) {
            if (s != w) continue;
            return true;
        }
        LazyIntIterator pred = this.transpose.successors(v);
        while ((p = pred.nextInt()) != -1) {
            if (p != w) continue;
            return true;
        }
        return false;
    }

    public boolean removeEdge(Long e) {
        throw new UnsupportedOperationException();
    }

    public boolean removeVertex(Integer x) {
        throw new UnsupportedOperationException();
    }

    public boolean addEdge(Long e, Integer y, Integer arg2) {
        throw new UnsupportedOperationException();
    }

    public boolean addEdge(Long e, Integer y, Integer arg2, EdgeType arg3) {
        throw new UnsupportedOperationException();
    }

    public boolean addEdge(Long e, Collection<? extends Integer> y) {
        throw new UnsupportedOperationException();
    }

    public boolean addEdge(Long e, Collection<? extends Integer> y, EdgeType arg2) {
        throw new UnsupportedOperationException();
    }

    public boolean addVertex(Integer x) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        boolean offline;
        ImmutableGraph graph;
        SimpleJSAP simpleJSAP = new SimpleJSAP(JungAdapter.class.getName(), "Reads a graph with a given basename, optionally its transpose, and writes it on standard output in Pajek format.", new Parameter[]{new Switch("offline", 'o', "offline", "Use the offline load method to reduce memory consumption. It usually works, but your mileage may vary."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph."), new UnflaggedOption("transpose", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the transpose. If unspecified, the JungAdapter constructor will be provided with null as a parameter. This usually works, but your mileage may vary.")});
        JSAPResult jsapResult = simpleJSAP.parse(arg);
        if (simpleJSAP.messagePrinted()) {
            System.exit(1);
        }
        ImmutableGraph immutableGraph = graph = (offline = jsapResult.userSpecified("offline")) ? ImmutableGraph.loadOffline(jsapResult.getString("basename")) : ImmutableGraph.load(jsapResult.getString("basename"));
        ImmutableGraph transpose = jsapResult.userSpecified("transpose") ? (offline ? ImmutableGraph.loadOffline(jsapResult.getString("transpose")) : ImmutableGraph.load(jsapResult.getString("transpose"))) : null;
        PrintWriter printWriter = new PrintWriter(System.out);
        new PajekNetWriter().save((Graph)new JungAdapter(graph, transpose), (Writer)printWriter);
        printWriter.flush();
    }
}

