/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.examples;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import it.unimi.dsi.webgraph.BVGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErdosRenyiGraph
extends ImmutableSequentialGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErdosRenyiGraph.class);
    private final int n;
    private final double p;
    private final boolean loops;
    private final long seed;

    public ErdosRenyiGraph(int n, double p, long seed, boolean loops) {
        this.n = n;
        this.p = p;
        this.loops = loops;
        this.seed = seed;
    }

    public ErdosRenyiGraph(int n, double p, boolean loops) {
        this(n, p, Util.randomSeed(), loops);
    }

    public ErdosRenyiGraph(int n, double p) {
        this(n, p, false);
    }

    public ErdosRenyiGraph(String n, String p, String seed, String loops) {
        this(Integer.parseInt(n), Double.parseDouble(p), Long.parseLong(seed), Boolean.parseBoolean(loops));
    }

    public ErdosRenyiGraph(String n, String p) {
        this(Integer.parseInt(n), Double.parseDouble(p));
    }

    public ErdosRenyiGraph(String n, String p, String loops) {
        this(Integer.parseInt(n), Double.parseDouble(p), Boolean.parseBoolean(loops));
    }

    public ErdosRenyiGraph(int n, long m, long seed, boolean loops) {
        this(n, (double)m / (double)(loops ? (long)n * (long)n : (long)n * (long)(n - 1)), seed, loops);
    }

    public ErdosRenyiGraph(int n, long m, boolean loops) {
        this(n, m, Util.randomSeed(), loops);
    }

    @Override
    public int numNodes() {
        return this.n;
    }

    @Override
    public ErdosRenyiGraph copy() {
        return this;
    }

    @Override
    public NodeIterator nodeIterator() {
        return new NodeIterator(){
            private final XoRoShiRo128PlusRandomGenerator random;
            private final BinomialDistribution bg;
            private int outdegree;
            private int curr;
            private final IntOpenHashSet successors;
            private int[] successorArray;
            {
                this.random = new XoRoShiRo128PlusRandomGenerator(ErdosRenyiGraph.this.seed);
                this.bg = new BinomialDistribution((RandomGenerator)this.random, ErdosRenyiGraph.this.n - (ErdosRenyiGraph.this.loops ? 0 : 1), ErdosRenyiGraph.this.p);
                this.curr = -1;
                this.successors = new IntOpenHashSet();
                this.successorArray = new int[1024];
            }

            public boolean hasNext() {
                return this.curr < ErdosRenyiGraph.this.n - 1;
            }

            public int nextInt() {
                ++this.curr;
                this.outdegree = this.bg.sample();
                this.successors.clear();
                if (!ErdosRenyiGraph.this.loops) {
                    this.successors.add(this.curr);
                }
                for (int i = 0; i < this.outdegree; ++i) {
                    while (!this.successors.add(this.random.nextInt(ErdosRenyiGraph.this.n))) {
                    }
                }
                if (!ErdosRenyiGraph.this.loops) {
                    this.successors.remove(this.curr);
                }
                this.successorArray = IntArrays.grow((int[])this.successorArray, (int)this.outdegree);
                this.successors.toArray(this.successorArray);
                IntArrays.quickSort((int[])this.successorArray, (int)0, (int)this.outdegree);
                return this.curr;
            }

            @Override
            public int outdegree() {
                return this.outdegree;
            }

            @Override
            public int[] successorArray() {
                return this.successorArray;
            }

            @Override
            public NodeIterator copy(int upperBound) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public ImmutableSequentialGraph generate(final long seed) {
        LOGGER.debug("Generating with probability " + this.p);
        return new ImmutableSequentialGraph(){

            @Override
            public int numNodes() {
                return ErdosRenyiGraph.this.n;
            }

            @Override
            public ImmutableSequentialGraph copy() {
                return this;
            }

            @Override
            public NodeIterator nodeIterator() {
                return new NodeIterator(){
                    private final XoRoShiRo128PlusRandomGenerator random;
                    private final BinomialDistribution bg;
                    private int outdegree;
                    private int curr;
                    private final IntOpenHashSet successors;
                    private int[] successorArray;
                    {
                        this.random = new XoRoShiRo128PlusRandomGenerator(seed);
                        this.bg = new BinomialDistribution((RandomGenerator)this.random, ErdosRenyiGraph.this.n - (ErdosRenyiGraph.this.loops ? 0 : 1), ErdosRenyiGraph.this.p);
                        this.curr = -1;
                        this.successors = new IntOpenHashSet();
                        this.successorArray = new int[1024];
                    }

                    public boolean hasNext() {
                        return this.curr < ErdosRenyiGraph.this.n - 1;
                    }

                    public int nextInt() {
                        ++this.curr;
                        this.outdegree = this.bg.sample();
                        this.successors.clear();
                        if (!ErdosRenyiGraph.this.loops) {
                            this.successors.add(this.curr);
                        }
                        for (int i = 0; i < this.outdegree; ++i) {
                            while (!this.successors.add(this.random.nextInt(ErdosRenyiGraph.this.n))) {
                            }
                        }
                        if (!ErdosRenyiGraph.this.loops) {
                            this.successors.remove(this.curr);
                        }
                        this.successorArray = IntArrays.grow((int[])this.successorArray, (int)this.outdegree);
                        this.successors.toIntArray(this.successorArray);
                        IntArrays.quickSort((int[])this.successorArray, (int)0, (int)this.outdegree);
                        return this.curr;
                    }

                    @Override
                    public int outdegree() {
                        return this.outdegree;
                    }

                    @Override
                    public int[] successorArray() {
                        return this.successorArray;
                    }

                    @Override
                    public NodeIterator copy(int upperBound) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Deprecated
    public ImmutableGraph generate() {
        return this.generate(Util.randomSeed());
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(ErdosRenyiGraph.class.getName(), "Generates an Erd\u0151s-R\u00e9nyi random graph and stores it as a BVGraph.", new Parameter[]{new Switch("loops", 'l', "loops", "Whether the graph should include self-loops."), new FlaggedOption("p", (StringParser)JSAP.DOUBLE_PARSER, JSAP.NO_DEFAULT, false, 'p', "The probability of generating an arc."), new FlaggedOption("m", (StringParser)JSAP.LONGSIZE_PARSER, JSAP.NO_DEFAULT, false, 'm', "The expected number of arcs."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the output graph file."), new UnflaggedOption("n", (StringParser)JSAP.INTEGER_PARSER, true, "The number of nodes.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String baseName = jsapResult.getString("basename");
        int n = jsapResult.getInt("n");
        boolean loops = jsapResult.getBoolean("loops");
        if (jsapResult.userSpecified("p") && jsapResult.userSpecified("m")) {
            System.err.println("Options p and m cannot be specified together");
            System.exit(1);
        }
        if (!jsapResult.userSpecified("p") && !jsapResult.userSpecified("m")) {
            System.err.println("Exactly one of the options p and m must be specified");
            System.exit(1);
        }
        BVGraph.store(jsapResult.userSpecified("p") ? new ErdosRenyiGraph(n, jsapResult.getDouble("p"), loops) : new ErdosRenyiGraph(n, jsapResult.getLong("m"), loops), baseName, new ProgressLogger());
    }
}

