/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.lang.EnumStringParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.Check;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.Transform;
import it.unimi.dsi.webgraph.algo.ConnectedComponents;
import it.unimi.dsi.webgraph.algo.SumSweepDirectedDiameterRadius;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumSweepUndirectedDiameterRadius {
    private static final boolean DEBUG = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SumSweepUndirectedDiameterRadius.class);
    private final ImmutableGraph graph;
    private final int nn;
    private final ProgressLogger pl;
    private final OutputLevel output;
    protected final int[] ecc;
    private final boolean[] toComplete;
    private final boolean[] firstBranch;
    private final int[] queue;
    private final int[] dist;
    private int dL;
    private int rU;
    private int dV;
    private int rV;
    private int iter;
    protected int[] l;
    protected int[] u;
    private int iterR;
    private int iterD;
    private int iterAll;
    private final int[] totDist;

    public SumSweepUndirectedDiameterRadius(ImmutableGraph graph, OutputLevel output, ProgressLogger pl) {
        if (!Check.symmetry(graph)) {
            throw new IllegalArgumentException("The graph is not undirected.");
        }
        this.pl = pl;
        this.graph = graph;
        this.nn = graph.numNodes();
        this.ecc = new int[this.nn];
        this.totDist = new int[this.nn];
        this.l = new int[this.nn];
        this.u = new int[this.nn];
        this.toComplete = new boolean[this.nn];
        this.queue = new int[this.nn];
        this.dist = new int[this.nn];
        this.firstBranch = new boolean[this.nn];
        Arrays.fill(this.ecc, -1);
        Arrays.fill(this.u, this.nn + 1);
        Arrays.fill(this.l, 0);
        Arrays.fill(this.toComplete, true);
        this.dL = 0;
        this.rU = Integer.MAX_VALUE;
        this.output = output;
        this.iterR = -1;
        this.iterD = -1;
        this.iterAll = -1;
    }

    public int getRadius() {
        if (this.iterR == -1) {
            throw new UnsupportedOperationException("The radius has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.rU;
    }

    public int getDiameter() {
        if (this.iterD == -1) {
            throw new UnsupportedOperationException("The diameter has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.dL;
    }

    public int getRadialVertex() {
        if (this.iterR == -1) {
            throw new UnsupportedOperationException("The radius has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.rV;
    }

    public int getDiametralVertex() {
        if (this.iterD == -1) {
            throw new UnsupportedOperationException("The radius has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.dV;
    }

    public int getEccentricity(int v) {
        if (this.ecc[v] == -1) {
            throw new UnsupportedOperationException("The eccentricity of v has not beencomputed, yet. Please, use the compute method withthe correct output.");
        }
        return this.ecc[v];
    }

    public int getRadiusIterations() {
        if (this.iterR == -1) {
            throw new UnsupportedOperationException("The radius has not been computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterR;
    }

    public int getDiameterIterations() {
        if (this.iterD == -1) {
            throw new UnsupportedOperationException("The diameter has not been computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterD;
    }

    public int getAllIterations() {
        if (this.iterAll == -1) {
            throw new UnsupportedOperationException("All eccentricities have not been  computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterAll;
    }

    private void stepSumSweep(int start) {
        int[] successors;
        int w;
        if (start == -1) {
            return;
        }
        if (this.graph.outdegree(start) == 0) {
            this.rU = 0;
            this.rV = start;
            this.ecc[start] = 0;
            this.toComplete[start] = false;
            return;
        }
        ImmutableGraph g = this.graph;
        int[] queue = this.queue;
        int[] dist = this.dist;
        int startQ = 0;
        int endQ = 0;
        int v = start;
        int eccNotFirstBranch = 0;
        int[] l = this.l;
        int[] u = this.u;
        int[] totDist = this.totDist;
        int[] ecc = this.ecc;
        boolean[] firstBranch = this.firstBranch;
        boolean[] toComplete = this.toComplete;
        int startingPathL = 0;
        Arrays.fill(dist, -1);
        dist[start] = 0;
        if (g.outdegree(start) == 1) {
            int old = start;
            w = start;
            v = g.successors(start).nextInt();
            dist[v] = 1;
            ++startingPathL;
            while (g.outdegree(v) == 2) {
                successors = g.successorArray(v);
                old = w;
                w = v;
                v = successors[0] == old ? successors[1] : successors[0];
                dist[v] = dist[w] + 1;
                ++startingPathL;
            }
        }
        Arrays.fill(firstBranch, false);
        queue[endQ++] = v;
        successors = g.successorArray(v);
        if (g.outdegree(v) != 1) {
            if (dist[successors[0]] == -1) {
                firstBranch[successors[0]] = true;
            } else {
                firstBranch[successors[1]] = true;
            }
        }
        while (startQ < endQ) {
            v = queue[startQ++];
            LazyIntIterator iter = g.successors(v);
            if (!firstBranch[v]) {
                eccNotFirstBranch = dist[v];
            }
            while ((w = iter.nextInt()) != -1) {
                if (dist[w] != -1) continue;
                dist[w] = dist[v] + 1;
                queue[endQ++] = w;
                firstBranch[w] = firstBranch[w] || firstBranch[v];
            }
        }
        int eccStart = dist[queue[endQ - 1]];
        v = this.nn;
        while (v-- > 0) {
            if (dist[v] == -1) continue;
            int n = v;
            totDist[n] = totDist[n] + dist[v];
            if (!toComplete[v]) continue;
            int distv = dist[v];
            l[v] = Math.max(l[v], Math.max(eccStart - distv, distv));
            u[v] = firstBranch[v] ? Math.min(u[v], Math.max(eccStart - 2 - 2 * startingPathL + distv, distv + Math.max(0, eccNotFirstBranch - 2 * startingPathL))) : (distv < startingPathL ? Math.min(u[v], Math.max(distv, eccStart - distv)) : Math.min(u[v], Math.max(eccStart - 2 * startingPathL + distv, eccStart)));
            if (l[v] != u[v]) continue;
            toComplete[v] = false;
            ecc[v] = l[v];
            if (this.dL < ecc[v]) {
                this.dL = ecc[v];
                this.dV = v;
            }
            if (this.rU <= ecc[v]) continue;
            this.rU = ecc[v];
            this.rV = v;
        }
        ++this.iter;
        if (this.pl != null) {
            this.pl.update();
        }
    }

    public void sumSweepHeuristic(int start, int iter) {
        this.stepSumSweep(start);
        for (int i = 2; i < iter; ++i) {
            this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.totDist, this.l, this.toComplete));
        }
    }

    private int findMissingNodes() {
        int missingR = 0;
        int missingD = 0;
        int missingAll = 0;
        boolean[] toComplete = this.toComplete;
        int[] u = this.u;
        int[] l = this.l;
        int v = this.nn;
        while (v-- > 0) {
            if (!toComplete[v]) continue;
            ++missingAll;
            if (u[v] > this.dL) {
                ++missingD;
            }
            if (l[v] >= this.rU) continue;
            ++missingR;
        }
        if (missingR == 0 && this.iterR == -1) {
            this.iterR = this.iter;
        }
        if (missingD == 0 && this.iterD == -1) {
            this.iterD = this.iter;
        }
        if (missingAll == 0) {
            this.iterAll = this.iter;
        }
        switch (this.output) {
            case RADIUS: {
                return missingR;
            }
            case DIAMETER: {
                return missingD;
            }
            case RADIUSDIAMETER: {
                return missingR + missingD;
            }
        }
        return missingAll;
    }

    public void compute() {
        int missingNodes;
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.itemsName = "nodes";
            this.pl.displayLocalSpeed = true;
        }
        int maxDeg = Integer.MIN_VALUE;
        int maxDegVert = -1;
        for (int v = 0; v < this.nn; ++v) {
            if (this.graph.outdegree(v) <= maxDeg) continue;
            maxDeg = this.graph.outdegree(v);
            maxDegVert = v;
        }
        this.sumSweepHeuristic(maxDegVert, 3);
        double[] points = new double[3];
        int oldMissingNodes = missingNodes = this.findMissingNodes();
        Arrays.fill(points, (double)this.graph.numNodes());
        while (missingNodes > 0) {
            int stepToPerform = SumSweepDirectedDiameterRadius.argMax(points);
            switch (stepToPerform) {
                case 0: {
                    LOGGER.debug("Performing a BFS from a vertex maximizing the upper bound.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.u, this.totDist, this.toComplete));
                    break;
                }
                case 1: {
                    LOGGER.debug("Performing a BFS from a vertex minimizing the lower bound.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMin(this.l, this.totDist, this.toComplete));
                    break;
                }
                case 2: {
                    LOGGER.debug("Performing a BFS from a vertex maximizing the distance sum.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.totDist, this.u, this.toComplete));
                }
            }
            oldMissingNodes = missingNodes;
            missingNodes = this.findMissingNodes();
            points[stepToPerform] = oldMissingNodes - missingNodes;
            for (int j = 0; j < points.length; ++j) {
                if (j == stepToPerform) continue;
                points[j] = points[j] + 2.0 / (double)this.iter;
            }
            LOGGER.debug("    Missing nodes: " + missingNodes + "/" + 2 * this.nn + ".");
        }
        if (this.output == OutputLevel.RADIUS || this.output == OutputLevel.RADIUSDIAMETER) {
            LOGGER.debug("Radius: " + this.rU + " (" + this.iterR + " iterations).");
        }
        if (this.output == OutputLevel.DIAMETER || this.output == OutputLevel.RADIUSDIAMETER) {
            LOGGER.debug("Diameter: " + this.dL + " (" + this.iterD + " iterations).");
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(SumSweepUndirectedDiameterRadius.class.getName(), "Computes the diameter, radius, diameter and radius, or all eccentricities in a graph, using the ExactSumSweep algorithm.", new Parameter[]{new Switch("expand", 'e', "expand", "Expand the graph to increase speed (no compression)."), new Switch("onlyGiant", 'g', "onlyGiant", "Performs the computation only for the biggest component of the input graph."), new Switch("symmetrize", 's', "symmetrize", "Symmetrizes the graph (so that also directed graphs can be input)."), new Switch("mapped", 'm', "mapped", "Use loadMapped() to load the graph."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("outputFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The filename where the resulting backward eccentricities (integers in binary form) are stored. If not available, the output file is not produced."), new FlaggedOption("level", (StringParser)EnumStringParser.getParser(OutputLevel.class, (boolean)true), OutputLevel.ALL.name(), false, 'l', "level", Arrays.toString((Object[])OutputLevel.values()))});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean mapped = jsapResult.getBoolean("mapped", false);
        boolean onlyGiant = jsapResult.getBoolean("onlyGiant", false);
        boolean symmetrize = jsapResult.getBoolean("symmetrize", false);
        String graphBasename = jsapResult.getString("graphBasename");
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        OutputLevel level = Enum.valueOf(OutputLevel.class, jsapResult.getObject("level").toString().toUpperCase());
        String forwardOutputFilename = jsapResult.getString("outputFilename");
        progressLogger.displayFreeMemory = true;
        progressLogger.displayLocalSpeed = true;
        ImmutableGraph immutableGraph = graph = mapped ? ImmutableGraph.loadMapped(graphBasename, progressLogger) : ImmutableGraph.load(graphBasename, progressLogger);
        if (jsapResult.userSpecified("expand")) {
            graph = new ArrayListMutableGraph(graph).immutableView();
        }
        if (symmetrize) {
            graph = Transform.symmetrize(graph);
        }
        if (onlyGiant) {
            graph = ConnectedComponents.getLargestComponent(graph, 0, null);
        }
        SumSweepUndirectedDiameterRadius ss = new SumSweepUndirectedDiameterRadius(graph, level, progressLogger);
        ss.compute();
        if (level != OutputLevel.DIAMETER) {
            System.out.println("Radius: " + ss.rU + " (" + ss.iterR + " iterations).");
        }
        if (level != OutputLevel.RADIUS) {
            System.out.println("Diameter: " + ss.dL + " (" + ss.iterD + " iterations).");
        }
        System.out.println("Total number of iterations: " + ss.iter + ".");
        if (forwardOutputFilename != null && level == OutputLevel.ALL) {
            BinIO.storeInts((int[])ss.ecc, (CharSequence)forwardOutputFilename);
        }
    }

    public static enum OutputLevel {
        RADIUS,
        DIAMETER,
        RADIUSDIAMETER,
        ALL;

    }
}

