/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetweennessCentrality {
    private static final Logger LOGGER = LoggerFactory.getLogger(BetweennessCentrality.class);
    private final ImmutableGraph graph;
    private final ProgressLogger pl;
    private final int numberOfThreads;
    protected final AtomicInteger nextNode;
    protected volatile boolean stop;
    public final double[] betweenness;

    public BetweennessCentrality(ImmutableGraph graph, int requestedThreads, ProgressLogger pl) {
        this.pl = pl;
        this.graph = graph;
        this.betweenness = new double[graph.numNodes()];
        this.nextNode = new AtomicInteger();
        this.numberOfThreads = requestedThreads != 0 ? requestedThreads : Runtime.getRuntime().availableProcessors();
    }

    public BetweennessCentrality(ImmutableGraph graph, ProgressLogger pl) {
        this(graph, 0, pl);
    }

    public BetweennessCentrality(ImmutableGraph graph, int requestedThreads) {
        this(graph, 1, null);
    }

    public BetweennessCentrality(ImmutableGraph graph) {
        this(graph, 0);
    }

    public void compute() throws InterruptedException {
        IterationThread[] thread = new IterationThread[this.numberOfThreads];
        for (int i = 0; i < thread.length; ++i) {
            thread[i] = new IterationThread();
        }
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.expectedUpdates = this.graph.numNodes();
            this.pl.itemsName = "nodes";
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int i = thread.length;
        while (i-- != 0) {
            executorCompletionService.submit(thread[i]);
        }
        try {
            i = thread.length;
            while (i-- != 0) {
                executorCompletionService.take().get();
            }
        }
        catch (ExecutionException e) {
            this.stop = true;
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause.getMessage(), cause);
        }
        finally {
            executorService.shutdown();
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public static void main(String[] arg) throws IOException, InterruptedException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(BetweennessCentrality.class.getName(), "Computes the betweenness centrality a graph using an implementation of Brandes's algorithm based on multiple parallel breadth-first visits.", new Parameter[]{new Switch("expand", 'e', "expand", "Expand the graph to increase speed (no compression)."), new Switch("mapped", 'm', "mapped", "Use loadMapped() to load the graph."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("rankFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the resulting rank (doubles in binary form) are stored.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean mapped = jsapResult.getBoolean("mapped", false);
        String graphBasename = jsapResult.getString("graphBasename");
        String rankFilename = jsapResult.getString("rankFilename");
        int threads = jsapResult.getInt("threads");
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        progressLogger.displayFreeMemory = true;
        progressLogger.displayLocalSpeed = true;
        ImmutableGraph immutableGraph = graph = mapped ? ImmutableGraph.loadMapped(graphBasename, progressLogger) : ImmutableGraph.load(graphBasename, progressLogger);
        if (jsapResult.userSpecified("expand")) {
            graph = new ArrayListMutableGraph(graph).immutableView();
        }
        BetweennessCentrality betweennessCentralityMultipleVisits = new BetweennessCentrality(graph, threads, progressLogger);
        betweennessCentralityMultipleVisits.compute();
        BinIO.storeDoubles((double[])betweennessCentralityMultipleVisits.betweenness, (CharSequence)rankFilename);
    }

    private final class IterationThread
    implements Callable<Void> {
        private final IntArrayList queue;
        private final IntArrayList cutPoints;
        private final int[] distance;
        private final long[] sigma;
        private final double[] delta;

        private IterationThread() {
            this.distance = new int[BetweennessCentrality.this.graph.numNodes()];
            this.sigma = new long[BetweennessCentrality.this.graph.numNodes()];
            this.delta = new double[BetweennessCentrality.this.graph.numNodes()];
            this.queue = new IntArrayList(BetweennessCentrality.this.graph.numNodes());
            this.cutPoints = new IntArrayList();
        }

        private boolean checkOverflow(long[] sigma, int node, long currSigma, int s) {
            if (sigma[s] > Long.MAX_VALUE - currSigma) {
                throw new PathCountOverflowException(sigma[s] + " > " + (Long.MAX_VALUE - currSigma) + " (" + node + " -> " + s + ")");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            int[] distance = this.distance;
            double[] delta = this.delta;
            long[] sigma = this.sigma;
            IntArrayList queue = this.queue;
            ImmutableGraph graph = BetweennessCentrality.this.graph.copy();
            while (true) {
                int s;
                int node;
                int end;
                int start;
                int curr = BetweennessCentrality.this.nextNode.getAndIncrement();
                if (BetweennessCentrality.this.stop || curr >= graph.numNodes()) {
                    return null;
                }
                queue.clear();
                queue.add(curr);
                this.cutPoints.clear();
                this.cutPoints.add(0);
                Arrays.fill(distance, -1);
                Arrays.fill(sigma, 0L);
                distance[curr] = 0;
                sigma[curr] = 1L;
                boolean overflow = false;
                int d = 0;
                while (queue.size() != this.cutPoints.getInt(this.cutPoints.size() - 1)) {
                    this.cutPoints.add(queue.size());
                    start = this.cutPoints.getInt(d);
                    end = this.cutPoints.getInt(d + 1);
                    for (int pos = start; pos < end; ++pos) {
                        node = queue.getInt(pos);
                        long currSigma = sigma[node];
                        LazyIntIterator successors = graph.successors(node);
                        while ((s = successors.nextInt()) != -1) {
                            if (distance[s] == -1) {
                                distance[s] = d + 1;
                                delta[s] = 0.0;
                                queue.add(s);
                                assert (this.checkOverflow(sigma, node, currSigma, s));
                                overflow |= sigma[s] > Long.MAX_VALUE - currSigma;
                                int n = s;
                                sigma[n] = sigma[n] + currSigma;
                                continue;
                            }
                            if (distance[s] != d + 1) continue;
                            assert (this.checkOverflow(sigma, node, currSigma, s));
                            overflow |= sigma[s] > Long.MAX_VALUE - currSigma;
                            int n = s;
                            sigma[n] = sigma[n] + currSigma;
                        }
                    }
                    ++d;
                }
                if (overflow) {
                    throw new PathCountOverflowException();
                }
                while (--d > 0) {
                    start = this.cutPoints.getInt(d);
                    end = this.cutPoints.getInt(d + 1);
                    for (int pos = start; pos < end; ++pos) {
                        node = queue.getInt(pos);
                        double sigmaNode = sigma[node];
                        LazyIntIterator succ = graph.successors(node);
                        while ((s = succ.nextInt()) != -1) {
                            if (distance[s] != d + 1) continue;
                            int n = node;
                            delta[n] = delta[n] + (1.0 + delta[s]) * sigmaNode / (double)sigma[s];
                        }
                    }
                    BetweennessCentrality betweennessCentrality = BetweennessCentrality.this;
                    synchronized (betweennessCentrality) {
                        for (int pos = start; pos < end; ++pos) {
                            int node2;
                            int n = node2 = queue.getInt(pos);
                            BetweennessCentrality.this.betweenness[n] = BetweennessCentrality.this.betweenness[n] + delta[node2];
                        }
                    }
                }
                if (BetweennessCentrality.this.pl == null) continue;
                ProgressLogger progressLogger = BetweennessCentrality.this.pl;
                synchronized (progressLogger) {
                    BetweennessCentrality.this.pl.update();
                }
            }
        }
    }

    public static final class PathCountOverflowException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PathCountOverflowException() {
        }

        public PathCountOverflowException(String s) {
            super(s);
        }
    }
}

