/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.webgraph.LazyIntIterator;

public class IntIntervalSequenceIterator
implements LazyIntIterator {
    private final int[] left;
    private final int[] len;
    private int remaining;
    private int currInterval;
    private int currIndex;
    private int currLeft;

    public IntIntervalSequenceIterator(int[] left, int[] len) {
        this(left, len, left.length);
    }

    public IntIntervalSequenceIterator(int[] left, int[] len, int n) {
        this.left = left;
        this.len = len;
        this.remaining = n;
        if (n != 0) {
            this.currLeft = left[0];
        }
    }

    private void advance() {
        --this.remaining;
        if (this.remaining != 0) {
            this.currLeft = this.left[++this.currInterval];
        }
        this.currIndex = 0;
    }

    @Override
    public int nextInt() {
        if (this.remaining == 0) {
            return -1;
        }
        int next = this.currLeft + this.currIndex++;
        if (this.currIndex == this.len[this.currInterval]) {
            this.advance();
        }
        return next;
    }

    @Override
    public int skip(int n) {
        int skipped;
        for (skipped = 0; skipped < n && this.remaining != 0; skipped += this.len[this.currInterval] - this.currIndex) {
            if (n - skipped < this.len[this.currInterval] - this.currIndex) {
                this.currIndex += n - skipped;
                return n;
            }
            this.advance();
        }
        return skipped;
    }
}

