/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.HuTuckerTransformationStrategy;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FileLinesByteArrayIterable;
import it.unimi.dsi.io.FileLinesMutableStringIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.SparseRank;
import it.unimi.dsi.sux4j.bits.SparseSelect;
import it.unimi.dsi.sux4j.io.BucketedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.GOV3Function;
import it.unimi.dsi.sux4j.mph.VLPaCoTrieDistributor;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Serializable,
Size64 {
    public static final long serialVersionUID = 4L;
    private static final Logger LOGGER = LoggerFactory.getLogger(VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.class);
    private static final boolean ASSERTS = false;
    private final long size;
    private final int bucketSize;
    private final int log2BucketSize;
    private final TransformationStrategy<? super T> transform;
    private final VLPaCoTrieDistributor<BitVector> distributor;
    private final GOV3Function<BitVector> offset;
    private SparseSelect select;

    public long getLong(Object o) {
        if (this.size == 0L) {
            return this.defRetValue;
        }
        BitVector bv = this.transform.toBitVector(o).fast();
        long bucket = this.distributor.getLong(bv);
        return (bucket == 0L ? 0L : this.select.select(bucket - 1L)) + this.offset.getLong(bv);
    }

    public VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction(Iterable<? extends T> elements, TransformationStrategy<? super T> transform) throws IOException {
        SparseRank sparseRank;
        this.transform = transform;
        this.defRetValue = -1L;
        long maxLength = 0L;
        long totalLength = 0L;
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        pl.itemsName = "keys";
        pl.start((CharSequence)"Creating chunked hash store...");
        BucketedHashStore<BitVector> bucketedHashStore = new BucketedHashStore<BitVector>(TransformationStrategies.identity());
        bucketedHashStore.reset(random.nextLong());
        for (T s : elements) {
            BitVector bv = transform.toBitVector(s);
            bucketedHashStore.add(bv);
            maxLength = Math.max(maxLength, bv.length());
            totalLength += bv.length();
            pl.lightUpdate();
        }
        pl.done();
        this.size = bucketedHashStore.size();
        if (this.size == 0L) {
            this.log2BucketSize = 0;
            this.bucketSize = 0;
            this.distributor = null;
            this.offset = null;
            bucketedHashStore.close();
            return;
        }
        long averageLength = (totalLength + this.size - 1L) / this.size;
        int t = Fast.mostSignificantBit((int)((int)Math.floor((double)averageLength - Math.log(this.size) - Math.log((double)averageLength - Math.log(this.size)) - 1.0)));
        int firstbucketSize = 1 << t;
        LOGGER.debug("First bucket size estimate: " + firstbucketSize);
        Iterable bitVectors = TransformationStrategies.wrap(elements, transform);
        VLPaCoTrieDistributor firstDistributor = new VLPaCoTrieDistributor(bitVectors, this.size, firstbucketSize, TransformationStrategies.identity());
        this.log2BucketSize = firstDistributor.numBits() == 0L || (long)firstbucketSize >= this.size ? t : t - Fast.mostSignificantBit((int)((int)Math.ceil((double)this.size / ((double)firstDistributor.numBits() * Math.log(2.0)))));
        this.bucketSize = 1 << this.log2BucketSize;
        LOGGER.debug("Second bucket size estimate: " + this.bucketSize);
        if (firstbucketSize == this.bucketSize) {
            this.distributor = firstDistributor;
        } else {
            firstDistributor = null;
            this.distributor = new VLPaCoTrieDistributor(bitVectors, this.size, this.bucketSize, TransformationStrategies.identity());
        }
        LOGGER.info("Bucket size: " + this.bucketSize);
        if (this.size > (long)(2 * this.bucketSize)) {
            sparseRank = new SparseRank(this.distributor.offset.getLong(this.distributor.offset.size64() - 1L) + 1L, this.distributor.offset.size64(), (LongIterator)this.distributor.offset.iterator());
            this.select = sparseRank.getSelect();
        } else {
            sparseRank = null;
            this.select = null;
        }
        this.offset = this.size > 0L ? new GOV3Function.Builder().keys(bitVectors).transform(TransformationStrategies.identity()).store(bucketedHashStore).values((LongIterable)new AbstractLongBigList(){

            public long getLong(long index) {
                long rank = sparseRank == null ? 0L : (index < ((VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction)VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.this).distributor.offset.getLong(((VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction)VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.this).distributor.offset.size64() - 1L) + 1L ? sparseRank.rank(index) : ((VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction)VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.this).distributor.offset.size64());
                return rank == 0L ? index : index - ((VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction)VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.this).distributor.offset.getLong(rank - 1L);
            }

            public long size64() {
                return VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.this.size;
            }
        }, this.log2BucketSize + 1).indirect().build() : null;
        bucketedHashStore.close();
        LOGGER.debug("Forecast distributor bit cost: " + (double)(this.size / (long)this.bucketSize) * ((double)(maxLength + (long)this.log2BucketSize) - Math.log(this.size)));
        LOGGER.debug("Actual distributor bit cost: " + this.distributor.numBits());
        LOGGER.debug("Forecast bit cost per element: " + (GOV3Function.C + Fast.log2((double)Math.E) - Fast.log2((double)Fast.log2((double)Math.E)) + Fast.log2((double)((double)maxLength - Fast.log2((double)this.size)))));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    public long numBits() {
        return this.distributor.numBits() + (this.offset == null ? 0L : this.offset.numBits()) + this.transform.numBits() + (this.select == null ? 0L : this.select.numBits());
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction.class.getName(), "Builds a variable-length PaCo trie-based monotone minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("decompressor", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'd', "decompressor", "Use this extension of InputStream to decompress the strings (e.g., java.util.zip.GZIPInputStream)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised monotone minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the second case, strings must be fewer than 2^31 and will be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        Class<GZIPInputStream> decompressor = jsapResult.getClass("decompressor");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean huTucker = jsapResult.getBoolean("huTucker");
        if (zipped && decompressor != null) {
            throw new IllegalArgumentException("The zipped and decompressor options are incompatible");
        }
        if (zipped) {
            decompressor = GZIPInputStream.class;
        }
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || huTucker || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayIterable keys = new FileLinesByteArrayIterable(stringFile, decompressor);
            BinIO.storeObject(new VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction(keys, TransformationStrategies.prefixFreeByteArray()), (CharSequence)functionName);
        } else {
            ObjectArrayList keys;
            if ("-".equals(stringFile)) {
                ObjectArrayList list;
                keys = list = new ObjectArrayList();
                FileLinesMutableStringIterable.iterator((InputStream)System.in, (Charset)encoding, decompressor).forEachRemaining(s -> list.add((Object)s.toString()));
            } else {
                keys = new FileLinesMutableStringIterable(stringFile, encoding, decompressor);
            }
            HuTuckerTransformationStrategy transformationStrategy = huTucker ? new HuTuckerTransformationStrategy((Iterable)keys, true) : (iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16()));
            BinIO.storeObject(new VLPaCoTrieDistributorMonotoneMinimalPerfectHashFunction(keys, transformationStrategy), (CharSequence)functionName);
        }
        LOGGER.info("Completed.");
    }
}

