/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.sux4j.mph.Hashes;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypergraphSorter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HypergraphSorter.class);
    public static final double GAMMA = 1.23;
    public final int numVertices;
    public final int partSize;
    public final int numEdges;
    public final int[] vertex1;
    public final int[] vertex2;
    public final int[] edge;
    public final int[] stack;
    private final int[] d;
    private final boolean computeEdges;
    private boolean neverUsed;
    private int top;

    public HypergraphSorter(int numEdges, boolean computeEdges) {
        this.numEdges = numEdges;
        this.computeEdges = computeEdges;
        int m = numEdges == 0 ? 0 : (int)Math.ceil(1.23 * (double)numEdges) + 1;
        this.numVertices = m + (3 - m % 3) % 3;
        this.partSize = this.numVertices / 3;
        this.vertex1 = new int[this.numVertices];
        this.vertex2 = new int[this.numVertices];
        this.edge = computeEdges ? new int[this.numVertices] : null;
        this.stack = new int[this.numVertices];
        this.d = new int[this.numVertices];
        this.neverUsed = true;
    }

    public HypergraphSorter(int numEdges) {
        this(numEdges, true);
    }

    public static void bitVectorToEdge(BitVector bv, long seed, int numVertices, int partSize, int[] e) {
        if (numVertices == 0) {
            e[2] = -1;
            e[1] = -1;
            e[0] = -1;
            return;
        }
        long[] hash = new long[3];
        Hashes.spooky4(bv, seed, hash);
        e[0] = (int)((hash[0] & Long.MAX_VALUE) % (long)partSize);
        e[1] = (int)((long)partSize + (hash[1] & Long.MAX_VALUE) % (long)partSize);
        e[2] = (int)((long)(partSize << 1) + (hash[2] & Long.MAX_VALUE) % (long)partSize);
    }

    public static void bitVectorToEdge(BitVector bv, long seed, int numVertices, int[] e) {
        HypergraphSorter.bitVectorToEdge(bv, seed, numVertices, (int)((long)numVertices * 0xAAAAAAABL >>> 33), e);
    }

    public static void tripleToEdge(long[] triple, long seed, int numVertices, int partSize, int[] e) {
        if (numVertices == 0) {
            e[2] = -1;
            e[1] = -1;
            e[0] = -1;
            return;
        }
        long[] hash = new long[3];
        Hashes.spooky4(triple, seed, hash);
        e[0] = (int)((hash[0] & Long.MAX_VALUE) % (long)partSize);
        e[1] = (int)((long)partSize + (hash[1] & Long.MAX_VALUE) % (long)partSize);
        e[2] = (int)((long)(partSize << 1) + (hash[2] & Long.MAX_VALUE) % (long)partSize);
    }

    public static void tripleToEdge(long[] triple, long seed, int numVertices, int[] e) {
        HypergraphSorter.tripleToEdge(triple, seed, numVertices, (int)((long)numVertices * 0xAAAAAAABL >>> 33), e);
    }

    private final void cleanUpIfNecessary() {
        if (!this.neverUsed) {
            Arrays.fill(this.d, 0);
            Arrays.fill(this.vertex1, 0);
            Arrays.fill(this.vertex2, 0);
            if (this.computeEdges) {
                Arrays.fill(this.edge, 0);
            }
        }
        this.neverUsed = false;
    }

    private final void xorEdge(int k, int x, int y, int z, boolean partial) {
        if (this.computeEdges) {
            if (!partial) {
                int n = x;
                this.edge[n] = this.edge[n] ^ k;
            }
            int n = y;
            this.edge[n] = this.edge[n] ^ k;
            int n2 = z;
            this.edge[n2] = this.edge[n2] ^ k;
        }
        if (!partial) {
            if (y < z) {
                int n = x;
                this.vertex1[n] = this.vertex1[n] ^ y;
                int n3 = x;
                this.vertex2[n3] = this.vertex2[n3] ^ z;
            } else {
                int n = x;
                this.vertex1[n] = this.vertex1[n] ^ z;
                int n4 = x;
                this.vertex2[n4] = this.vertex2[n4] ^ y;
            }
        }
        if (x < z) {
            int n = y;
            this.vertex1[n] = this.vertex1[n] ^ x;
            int n5 = y;
            this.vertex2[n5] = this.vertex2[n5] ^ z;
        } else {
            int n = y;
            this.vertex1[n] = this.vertex1[n] ^ z;
            int n6 = y;
            this.vertex2[n6] = this.vertex2[n6] ^ x;
        }
        if (x < y) {
            int n = z;
            this.vertex1[n] = this.vertex1[n] ^ x;
            int n7 = z;
            this.vertex2[n7] = this.vertex2[n7] ^ y;
        } else {
            int n = z;
            this.vertex1[n] = this.vertex1[n] ^ y;
            int n8 = z;
            this.vertex2[n8] = this.vertex2[n8] ^ x;
        }
    }

    public boolean generateAndSort(Iterator<? extends T> iterator, TransformationStrategy<? super T> transform, long seed) {
        int[] d = this.d;
        int[] e = new int[3];
        this.cleanUpIfNecessary();
        for (int k = 0; k < this.numEdges; ++k) {
            HypergraphSorter.bitVectorToEdge(transform.toBitVector(iterator.next()), seed, this.numVertices, this.partSize, e);
            this.xorEdge(k, e[0], e[1], e[2], false);
            int n = e[0];
            d[n] = d[n] + 1;
            int n2 = e[1];
            d[n2] = d[n2] + 1;
            int n3 = e[2];
            d[n3] = d[n3] + 1;
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("This " + HypergraphSorter.class.getSimpleName() + " has " + this.numEdges + " edges, but the provided iterator returns more");
        }
        return this.sort();
    }

    public boolean generateAndSort(Iterator<long[]> iterator, long seed) {
        int[] d = this.d;
        int[] e = new int[3];
        this.cleanUpIfNecessary();
        for (int k = 0; k < this.numEdges; ++k) {
            HypergraphSorter.tripleToEdge(iterator.next(), seed, this.numVertices, this.partSize, e);
            this.xorEdge(k, e[0], e[1], e[2], false);
            int n = e[0];
            d[n] = d[n] + 1;
            int n2 = e[1];
            d[n2] = d[n2] + 1;
            int n3 = e[2];
            d[n3] = d[n3] + 1;
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("This " + HypergraphSorter.class.getSimpleName() + " has " + this.numEdges + " edges, but the provided iterator returns more");
        }
        return this.sort();
    }

    private boolean sort() {
        int[] d = this.d;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Peeling hypergraph...");
        }
        this.top = 0;
        for (int x = 0; x < this.numVertices; ++x) {
            if (d[x] != 1) continue;
            this.peel(x);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((String)(this.top == this.numEdges ? "Peeling completed." : "Visit failed: peeled " + this.top + " edges out of " + this.numEdges + "."));
        }
        return this.top == this.numEdges;
    }

    private void peel(int x) {
        int[] vertex1 = this.vertex1;
        int[] vertex2 = this.vertex2;
        int[] edge = this.edge;
        int[] stack = this.stack;
        int[] d = this.d;
        int pos = this.top;
        int curr = this.top;
        stack[this.top++] = x;
        while (pos < this.top) {
            int v;
            if (d[v = stack[pos++]] != 1) continue;
            stack[curr++] = v;
            int n = v;
            d[n] = d[n] - 1;
            this.xorEdge(this.computeEdges ? edge[v] : -1, v, vertex1[v], vertex2[v], true);
            int n2 = vertex1[v];
            d[n2] = d[n2] - 1;
            if (d[n2] == 1) {
                stack[this.top++] = vertex1[v];
            }
            int n3 = vertex2[v];
            d[n3] = d[n3] - 1;
            if (d[n3] != 1) continue;
            stack[this.top++] = vertex2[v];
        }
        this.top = curr;
    }
}

