/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.io;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigLists;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ChunkedHashStore<T>
implements Serializable,
SafelyCloseable,
Iterable<Chunk> {
    public static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkedHashStore.class);
    private static final boolean DEBUG = false;
    public static final int BUFFER_SIZE = 16384;
    public static final int LOG2_DISK_CHUNKS = 8;
    public static final int DISK_CHUNKS = 256;
    public static final int DISK_CHUNKS_SHIFT = 56;
    protected long size;
    protected long filteredSize;
    protected long seed;
    private int[] count;
    private long chunks;
    private File[] file;
    private int diskChunkStep;
    private int chunkShift;
    private boolean checkedForDuplicates;
    private final TransformationStrategy<? super T> transform;
    private final ProgressLogger pl;
    private final long hashMask;
    private final File tempDir;
    private WritableByteChannel[] writableByteChannel;
    private ByteBuffer[] byteBuffer;
    private int virtualDiskChunks;
    private Predicate<long[]> filter;
    private boolean locked;
    private boolean closed;
    private long quickSortWallTime;
    private Long2LongOpenHashMap value2FrequencyMap;

    public ChunkedHashStore(TransformationStrategy<? super T> transform) throws IOException {
        this(transform, null, null);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, File tempDir) throws IOException {
        this(transform, tempDir, null);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, ProgressLogger pl) throws IOException {
        this(transform, null, pl);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, File tempDir, ProgressLogger pl) throws IOException {
        this(transform, tempDir, 0, pl);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, File tempDir, int hashWidthOrCountValues, ProgressLogger pl) throws IOException {
        this.transform = transform;
        this.pl = pl;
        this.tempDir = tempDir;
        long l = this.hashMask = hashWidthOrCountValues <= 0 ? 0L : -1L >>> -hashWidthOrCountValues;
        if (hashWidthOrCountValues < 0) {
            this.value2FrequencyMap = new Long2LongOpenHashMap();
        }
        this.file = new File[256];
        this.writableByteChannel = new WritableByteChannel[256];
        this.byteBuffer = new ByteBuffer[256];
        for (int i = 0; i < 256; ++i) {
            this.byteBuffer[i] = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
            this.file[i] = File.createTempFile(ChunkedHashStore.class.getSimpleName(), String.valueOf(i), tempDir);
            this.writableByteChannel[i] = new FileOutputStream(this.file[i]).getChannel();
            this.file[i].deleteOnExit();
        }
        this.count = new int[256];
    }

    public long seed() {
        this.locked = true;
        return this.seed;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public TransformationStrategy<? super T> transform() {
        return this.transform;
    }

    public void add(T o, long value) throws IOException {
        long[] triple = new long[3];
        Hashes.spooky4(this.transform.toBitVector(o), this.seed, triple);
        this.add(triple, value);
    }

    public void add(T o) throws IOException {
        this.add(o, this.filteredSize);
    }

    private void add(long[] triple, long value) throws IOException {
        int chunk;
        int n = chunk = (int)(triple[0] >>> 56);
        this.count[n] = this.count[n] + 1;
        this.checkedForDuplicates = false;
        ChunkedHashStore.writeLong(triple[0], this.byteBuffer[chunk], this.writableByteChannel[chunk]);
        ChunkedHashStore.writeLong(triple[1], this.byteBuffer[chunk], this.writableByteChannel[chunk]);
        ChunkedHashStore.writeLong(triple[2], this.byteBuffer[chunk], this.writableByteChannel[chunk]);
        if (this.hashMask == 0L) {
            ChunkedHashStore.writeLong(value, this.byteBuffer[chunk], this.writableByteChannel[chunk]);
        }
        if (this.filteredSize != -1L && (this.filter == null || this.filter.evaluate((Object)triple))) {
            ++this.filteredSize;
        }
        if (this.value2FrequencyMap != null) {
            this.value2FrequencyMap.addTo(value, 1L);
        }
        ++this.size;
    }

    public void addAll(Iterator<? extends T> elements, LongIterator values, boolean requiresValue2CountMap) throws IOException {
        if (this.pl != null) {
            this.pl.expectedUpdates = -1L;
            this.pl.start((CharSequence)"Adding elements...");
        }
        long[] triple = new long[3];
        while (elements.hasNext()) {
            Hashes.spooky4(this.transform.toBitVector(elements.next()), this.seed, triple);
            this.add(triple, values != null ? values.nextLong() : this.filteredSize);
            if (this.pl == null) continue;
            this.pl.lightUpdate();
        }
        if (values != null && values.hasNext()) {
            throw new IllegalStateException("The iterator on values contains more entries than the iterator on keys");
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public void addAll(Iterator<? extends T> elements, LongIterator values) throws IOException {
        this.addAll(elements, values, false);
    }

    public void addAll(Iterator<? extends T> elements) throws IOException {
        this.addAll(elements, null);
    }

    private void flushAll() throws IOException {
        for (int i = 0; i < 256; ++i) {
            ChunkedHashStore.flush(this.byteBuffer[i], this.writableByteChannel[i]);
        }
    }

    public long size() throws IOException {
        if (this.filter == null) {
            return this.size;
        }
        if (this.filteredSize == -1L) {
            long c = 0L;
            long[] triple = new long[3];
            ByteBuffer iteratorByteBuffer = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
            for (int i = 0; i < 256; ++i) {
                if (this.filter == null) {
                    c += (long)this.count[i];
                    continue;
                }
                this.flushAll();
                FileChannel channel = new FileInputStream(this.file[i]).getChannel();
                iteratorByteBuffer.clear().flip();
                for (int j = 0; j < this.count[i]; ++j) {
                    triple[0] = ChunkedHashStore.readLong(iteratorByteBuffer, channel);
                    triple[1] = ChunkedHashStore.readLong(iteratorByteBuffer, channel);
                    triple[2] = ChunkedHashStore.readLong(iteratorByteBuffer, channel);
                    if (this.hashMask == 0L) {
                        ChunkedHashStore.readLong(iteratorByteBuffer, channel);
                    }
                    if (!this.filter.evaluate((Object)triple)) continue;
                    ++c;
                }
                channel.close();
            }
            this.filteredSize = c;
        }
        return this.filteredSize;
    }

    public void clear() throws IOException {
        this.locked = false;
        if (this.value2FrequencyMap != null) {
            this.value2FrequencyMap = new Long2LongOpenHashMap();
        }
        this.reset(0L);
    }

    public Long2LongOpenHashMap value2FrequencyMap() {
        if (this.value2FrequencyMap == null) {
            throw new IllegalStateException("This chunked hash store does not contain a value frequency map");
        }
        return this.value2FrequencyMap;
    }

    private static void writeLong(long value, ByteBuffer byteBuffer, WritableByteChannel channel) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            ChunkedHashStore.flush(byteBuffer, channel);
        }
        byteBuffer.putLong(value);
    }

    private static void flush(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
    }

    private static long readLong(ByteBuffer byteBuffer, ReadableByteChannel channel) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            byteBuffer.clear();
            int result = channel.read(byteBuffer);
            assert (result != 0);
            if (result == -1) {
                throw new EOFException();
            }
            byteBuffer.flip();
        }
        return byteBuffer.getLong();
    }

    private static ReadableByteChannel concatenate(final ReadableByteChannel[] channel) {
        return new ReadableByteChannel(){
            private int curr = 0;
            private boolean closed;

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                for (ReadableByteChannel c : channel) {
                    c.close();
                }
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (!dst.hasRemaining()) {
                    return 0;
                }
                while (this.curr != channel.length) {
                    int result = channel[this.curr].read(dst);
                    if (result >= 0) {
                        return result;
                    }
                    if (result != -1) continue;
                    ++this.curr;
                }
                return -1;
            }
        };
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                LOGGER.warn("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed.");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            LOGGER.debug("Wall clock for quicksort: " + Util.format((double)((double)this.quickSortWallTime / 1.0E9)) + "s");
            this.closed = true;
            for (WritableByteChannel channel : this.writableByteChannel) {
                channel.close();
            }
            for (File f : this.file) {
                f.delete();
            }
        }
    }

    public void reset(long seed) throws IOException {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.filteredSize = 0L;
        this.seed = seed;
        this.checkedForDuplicates = false;
        java.util.Arrays.fill(this.count, 0);
        for (int i = 0; i < 256; ++i) {
            this.writableByteChannel[i].close();
            this.byteBuffer[i].clear();
            this.writableByteChannel[i] = new FileOutputStream(this.file[i]).getChannel();
        }
    }

    public void check() throws DuplicateException {
        for (Chunk b : this) {
            b.iterator();
        }
    }

    public void checkAndRetry(Iterable<? extends T> iterable, LongIterable values) throws IOException {
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator();
        int duplicates = 0;
        while (true) {
            try {
                this.check();
            }
            catch (DuplicateException e) {
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                this.reset(random.nextLong());
                this.addAll(iterable.iterator(), values.iterator());
                continue;
            }
            break;
        }
        this.checkedForDuplicates = true;
    }

    public void checkAndRetry(Iterable<? extends T> iterable) throws IOException {
        this.checkAndRetry(iterable, null);
    }

    public LongBigList signatures(int signatureWidth, ProgressLogger pl) throws IOException {
        LongBigList signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
        long signatureMask = -1L >>> -signatureWidth;
        signatures.size(this.size());
        pl.expectedUpdates = this.size();
        pl.itemsName = "signatures";
        pl.start((CharSequence)"Signing...");
        for (Chunk chunk : this) {
            Iterator<long[]> chunkIterator = chunk.iterator();
            int i = chunk.size();
            while (i-- != 0) {
                long[] quadruple = chunkIterator.next();
                signatures.set(quadruple[3], signatureMask & quadruple[0]);
                pl.lightUpdate();
            }
        }
        pl.done();
        return signatures;
    }

    public int log2Chunks(int log2chunks) {
        this.chunks = 1 << log2chunks;
        this.diskChunkStep = (int)Math.max(256L / this.chunks, 1L);
        this.virtualDiskChunks = 256 / this.diskChunkStep;
        this.chunkShift = 64 - log2chunks;
        LOGGER.debug("Number of chunks: " + this.chunks);
        LOGGER.debug("Number of disk chunks: 256");
        LOGGER.debug("Number of virtual disk chunks: " + this.virtualDiskChunks);
        return this.chunkShift;
    }

    public void filter(Predicate<long[]> filter) {
        this.filter = filter;
        this.filteredSize = -1L;
    }

    @Override
    public Iterator<Chunk> iterator() {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed ");
        }
        try {
            this.flushAll();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int m = 0;
        for (int i = 0; i < this.virtualDiskChunks; ++i) {
            int s = 0;
            for (int j = 0; j < this.diskChunkStep; ++j) {
                s += this.count[i * this.diskChunkStep + j];
            }
            if (s <= m) continue;
            m = s;
        }
        final int maxCount = m;
        return new ObjectIterator<Chunk>(){
            private int chunk;
            private ReadableByteChannel channel;
            private final ByteBuffer iteratorByteBuffer = ByteBuffer.allocateDirect(16384).order(ByteOrder.nativeOrder());
            private int last;
            private int chunkSize;
            private final long[] buffer0 = new long[maxCount];
            private final long[] buffer1 = new long[maxCount];
            private final long[] buffer2 = new long[maxCount];
            private final long[] data = ChunkedHashStore.access$700(ChunkedHashStore.this) != 0L ? null : new long[maxCount];

            public boolean hasNext() {
                return (long)this.chunk < ChunkedHashStore.this.chunks;
            }

            public Chunk next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                long[] buffer0 = this.buffer0;
                if ((long)this.chunk % (ChunkedHashStore.this.chunks / (long)ChunkedHashStore.this.virtualDiskChunks) == 0L) {
                    int diskChunk = (int)((long)this.chunk / (ChunkedHashStore.this.chunks / (long)ChunkedHashStore.this.virtualDiskChunks));
                    long[] buffer1 = this.buffer1;
                    long[] buffer2 = this.buffer2;
                    this.chunkSize = 0;
                    try {
                        if (ChunkedHashStore.this.diskChunkStep == 1) {
                            this.channel = new FileInputStream(ChunkedHashStore.this.file[diskChunk]).getChannel();
                            this.chunkSize = ChunkedHashStore.this.count[diskChunk];
                        } else {
                            ReadableByteChannel[] subChannel = new ReadableByteChannel[ChunkedHashStore.this.diskChunkStep];
                            for (int i = 0; i < ChunkedHashStore.this.diskChunkStep; ++i) {
                                subChannel[i] = new FileInputStream(ChunkedHashStore.this.file[diskChunk * ChunkedHashStore.this.diskChunkStep + i]).getChannel();
                                this.chunkSize += ChunkedHashStore.this.count[diskChunk * ChunkedHashStore.this.diskChunkStep + i];
                            }
                            this.channel = ChunkedHashStore.concatenate(subChannel);
                        }
                        this.iteratorByteBuffer.clear().flip();
                        long[] triple = new long[3];
                        int count = 0;
                        for (int j = 0; j < this.chunkSize; ++j) {
                            triple[0] = ChunkedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                            triple[1] = ChunkedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                            triple[2] = ChunkedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                            if (ChunkedHashStore.this.filter == null || ChunkedHashStore.this.filter.evaluate((Object)triple)) {
                                buffer0[count] = triple[0];
                                buffer1[count] = triple[1];
                                buffer2[count] = triple[2];
                                if (ChunkedHashStore.this.hashMask == 0L) {
                                    this.data[count] = ChunkedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                                }
                                ++count;
                                continue;
                            }
                            if (ChunkedHashStore.this.hashMask != 0L) continue;
                            ChunkedHashStore.readLong(this.iteratorByteBuffer, this.channel);
                        }
                        this.chunkSize = count;
                        this.channel.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    long start = System.nanoTime();
                    Arrays.parallelQuickSort((int)0, (int)this.chunkSize, (x, y) -> {
                        int t = Long.compareUnsigned(buffer0[x], buffer0[y]);
                        if (t != 0) {
                            return t;
                        }
                        t = Long.compareUnsigned(buffer1[x], buffer1[y]);
                        if (t != 0) {
                            return t;
                        }
                        return Long.compareUnsigned(buffer2[x], buffer2[y]);
                    }, (x, y) -> {
                        long e0 = buffer0[x];
                        long e1 = buffer1[x];
                        long e2 = buffer2[x];
                        buffer0[x] = buffer0[y];
                        buffer1[x] = buffer1[y];
                        buffer2[x] = buffer2[y];
                        buffer0[y] = e0;
                        buffer1[y] = e1;
                        buffer2[y] = e2;
                        if (ChunkedHashStore.this.hashMask == 0L) {
                            long v = this.data[x];
                            this.data[x] = this.data[y];
                            this.data[y] = v;
                        }
                    });
                    ChunkedHashStore.this.quickSortWallTime += System.nanoTime() - start;
                    this.last = 0;
                }
                int start = this.last;
                if (ChunkedHashStore.this.chunkShift < 64) {
                    int incr = 1;
                    while (this.last + incr < this.chunkSize && buffer0[this.last + incr] >>> ChunkedHashStore.this.chunkShift == (long)this.chunk) {
                        incr <<= 1;
                    }
                    int to = Math.min(this.chunkSize, this.last + incr);
                    this.last += incr >>> 1;
                    while (this.last < to) {
                        int mid = this.last + to >>> 1;
                        if (buffer0[mid] >>> ChunkedHashStore.this.chunkShift == (long)this.chunk) {
                            this.last = mid + 1;
                            continue;
                        }
                        to = mid;
                    }
                } else {
                    this.last = this.chunkSize;
                }
                if (!ChunkedHashStore.this.checkedForDuplicates && start < this.last) {
                    for (int i = start + 1; i < this.last; ++i) {
                        if (buffer0[i - 1] != buffer0[i] || this.buffer1[i - 1] != this.buffer1[i] || this.buffer2[i - 1] != this.buffer2[i]) continue;
                        throw new DuplicateException();
                    }
                }
                if ((long)this.chunk == ChunkedHashStore.this.chunks - 1L && this.last == this.chunkSize) {
                    ChunkedHashStore.this.checkedForDuplicates = true;
                }
                return new Chunk(this.chunk++, buffer0, this.buffer1, this.buffer2, this.data, ChunkedHashStore.this.hashMask, start, this.last);
            }
        };
    }

    public static final class Chunk
    implements Iterable<long[]> {
        private final int index;
        private final int start;
        private final int end;
        private final long[] buffer0;
        private final long[] buffer1;
        private final long[] buffer2;
        private final long[] data;
        private final long hashMask;

        private Chunk(int index, long[] buffer0, long[] buffer1, long[] buffer2, long[] data, long hashMask, int start, int end) {
            this.index = index;
            this.start = start;
            this.end = end;
            this.data = data;
            this.hashMask = hashMask;
            this.buffer0 = buffer0;
            this.buffer1 = buffer1;
            this.buffer2 = buffer2;
        }

        public Chunk(Chunk chunk) {
            this.index = chunk.index;
            this.hashMask = chunk.hashMask;
            this.start = 0;
            this.end = chunk.end - chunk.start;
            this.buffer0 = java.util.Arrays.copyOfRange(chunk.buffer0, chunk.start, chunk.end);
            this.buffer1 = java.util.Arrays.copyOfRange(chunk.buffer1, chunk.start, chunk.end);
            this.buffer2 = java.util.Arrays.copyOfRange(chunk.buffer2, chunk.start, chunk.end);
            this.data = chunk.data == null ? null : java.util.Arrays.copyOfRange(chunk.data, chunk.start, chunk.end);
        }

        public Chunk() {
            this.index = 0;
            this.start = 0;
            this.end = 0;
            this.data = null;
            this.hashMask = 0L;
            this.buffer0 = null;
            this.buffer1 = null;
            this.buffer2 = null;
        }

        public int size() {
            return this.end - this.start;
        }

        public int index() {
            return this.index;
        }

        public long data(long k) {
            return this.data != null ? this.data[(int)((long)this.start + k)] : this.buffer0[(int)((long)this.start + k)] & this.hashMask;
        }

        @Override
        public Iterator<long[]> iterator() {
            return new ObjectIterator<long[]>(){
                private int pos;
                private final long[] quadruple;
                {
                    this.pos = start;
                    this.quadruple = new long[4];
                }

                public boolean hasNext() {
                    return this.pos < end;
                }

                public long[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    long[] quadruple = this.quadruple;
                    quadruple[0] = buffer0[this.pos];
                    quadruple[1] = buffer1[this.pos];
                    quadruple[2] = buffer2[this.pos];
                    quadruple[3] = data != null ? data[this.pos] : buffer0[this.pos] & hashMask;
                    ++this.pos;
                    return quadruple;
                }
            };
        }

        public LongBigList valueList(final LongIterable values) {
            return new AbstractLongBigList(){
                private final LongBigList valueList;
                {
                    this.valueList = values == null ? null : (values instanceof LongList ? LongBigLists.asBigList((LongList)((LongList)values)) : (LongBigList)values);
                }

                public long size64() {
                    return this.size();
                }

                public long getLong(long index) {
                    return this.valueList == null ? this.data(index) : this.valueList.getLong(this.data(index));
                }
            };
        }
    }

    public static class DuplicateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

