/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.LongBigArrayBitVector;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.Select;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SimpleBigSelect
implements Select {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ONES_PER_INVENTORY = 8192;
    private static final int MAX_LOG2_LONGWORDS_PER_SUBINVENTORY = 3;
    private static final int MAX_SPAN = 65536;
    private final LongBigArrayBitVector bitVector;
    private final long numOnes;
    private final long numWords;
    private transient long[][] bits;
    private final long[] inventory;
    private final int log2OnesPerInventory;
    private final long onesPerInventory;
    private final long onesPerInventoryMask;
    private final long[] subinventory;
    private transient LongBigList subinventory16;
    private final int log2LongwordsPerSubinventory;
    private final int log2OnesPerSub64;
    private final int onesPerSub64;
    private final int log2OnesPerSub16;
    private final int onesPerSub16;
    private final int onesPerSub16Mask;
    private final long[] exactSpill;

    public SimpleBigSelect(long[][] bits, long length) {
        this(LongBigArrayBitVector.wrap((long[][])bits, (long)length));
    }

    public SimpleBigSelect(LongBigArrayBitVector bitVector) {
        this.bitVector = bitVector;
        this.bits = bitVector.bigBits();
        long length = bitVector.length();
        this.numWords = LongBigArrayBitVector.word((long)(length + 64L - 1L));
        long d = 0L;
        long[][] lArray = this.bits;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] s;
            for (long t : s = lArray[i]) {
                d += (long)Long.bitCount(t);
            }
        }
        this.log2OnesPerInventory = Fast.mostSignificantBit((long)(length == 0L ? 1L : (d * 8192L + length - 1L) / length));
        this.onesPerInventory = 1L << this.log2OnesPerInventory;
        this.onesPerInventoryMask = this.onesPerInventory - 1L;
        assert ((d + this.onesPerInventory - 1L) / this.onesPerInventory <= 0x7FFFFFF7L) : "Inventory too large: " + (d + this.onesPerInventory - 1L) / this.onesPerInventory;
        int inventorySize = (int)((d + this.onesPerInventory - 1L) / this.onesPerInventory);
        this.inventory = new long[inventorySize + 1];
        long numWords = this.numWords;
        long[] inventory = this.inventory;
        int log2OnesPerInventory = this.log2OnesPerInventory;
        long onesPerInventoryMask = this.onesPerInventoryMask;
        d = 0L;
        for (long i = 0L; i < numWords; ++i) {
            for (int j = 0; j < 64 && LongBigArrayBitVector.bits((long)i) + (long)j < length; ++j) {
                if ((BigArrays.get((long[][])this.bits, (long)i) & 1L << j) == 0L) continue;
                if ((d & onesPerInventoryMask) == 0L) {
                    inventory[(int)(d >>> log2OnesPerInventory)] = LongBigArrayBitVector.bits((long)i) + (long)j;
                }
                ++d;
            }
        }
        this.numOnes = d;
        inventory[inventorySize] = length;
        this.log2LongwordsPerSubinventory = Math.min(3, Math.max(0, log2OnesPerInventory - 2));
        this.log2OnesPerSub64 = Math.max(0, log2OnesPerInventory - this.log2LongwordsPerSubinventory);
        this.log2OnesPerSub16 = Math.max(0, this.log2OnesPerSub64 - 2);
        this.onesPerSub64 = 1 << this.log2OnesPerSub64;
        this.onesPerSub16 = 1 << this.log2OnesPerSub16;
        this.onesPerSub16Mask = this.onesPerSub16 - 1;
        long numOnes = this.numOnes;
        long onesPerInventory = this.onesPerInventory;
        int onesPerSub16 = this.onesPerSub16;
        int log2OnesPerSub16 = this.log2OnesPerSub16;
        int onesPerSub64 = this.onesPerSub64;
        if (onesPerInventory > 1L) {
            d = 0L;
            long diff16 = 0L;
            long start = 0L;
            long span = 0L;
            int spilled = 0;
            int inventoryIndex = 0;
            for (long i = 0L; i < numWords; ++i) {
                for (int j = 0; j < 64 && LongBigArrayBitVector.bits((long)i) + (long)j < length; ++j) {
                    if ((BigArrays.get((long[][])this.bits, (long)i) & 1L << j) == 0L) continue;
                    if ((d & onesPerInventoryMask) == 0L) {
                        inventoryIndex = (int)(d >>> log2OnesPerInventory);
                        start = inventory[inventoryIndex];
                        span = inventory[inventoryIndex + 1] - start;
                        long ones = (int)Math.min(numOnes - d, onesPerInventory);
                        diff16 += Math.max(4L, ones + (long)onesPerSub16 - 1L >>> log2OnesPerSub16);
                        if (span >= 65536L && onesPerSub64 > 1) {
                            spilled = (int)((long)spilled + ones);
                        }
                    }
                    ++d;
                }
            }
            int subinventorySize = (int)(diff16 + 3L >> 2);
            int exactSpillSize = spilled;
            this.subinventory = new long[subinventorySize];
            this.exactSpill = new long[exactSpillSize];
            this.subinventory16 = LongArrayBitVector.wrap((long[])this.subinventory).asLongBigList(16);
            long offset = 0L;
            spilled = 0;
            d = 0L;
            int onesPerSub16Mask = this.onesPerSub16Mask;
            int log2LongwordsPerSubinventory = this.log2LongwordsPerSubinventory;
            long[] subinventory = this.subinventory;
            LongBigList subinventory16 = this.subinventory16;
            for (long i = 0L; i < numWords; ++i) {
                for (int j = 0; j < 64 && LongBigArrayBitVector.bits((long)i) + (long)j < length; ++j) {
                    if ((BigArrays.get((long[][])this.bits, (long)i) & 1L << j) == 0L) continue;
                    if ((d & onesPerInventoryMask) == 0L) {
                        inventoryIndex = (int)(d >>> log2OnesPerInventory);
                        start = inventory[inventoryIndex];
                        span = inventory[inventoryIndex + 1] - start;
                        offset = 0L;
                    }
                    if (span < 65536L) {
                        assert (LongBigArrayBitVector.bits((long)i) + (long)j - start <= 65536L);
                        if ((d & (long)onesPerSub16Mask) == 0L) {
                            subinventory16.set(((long)inventoryIndex << log2LongwordsPerSubinventory + 2) + offset++, LongBigArrayBitVector.bits((long)i) + (long)j - start);
                        }
                    } else {
                        assert (onesPerSub64 > 1);
                        if ((d & onesPerInventoryMask) == 0L) {
                            int n2 = inventoryIndex;
                            inventory[n2] = inventory[n2] | Long.MIN_VALUE;
                            subinventory[inventoryIndex << log2LongwordsPerSubinventory] = spilled;
                        }
                        this.exactSpill[spilled++] = LongBigArrayBitVector.bits((long)i) + (long)j;
                    }
                    ++d;
                }
            }
        } else {
            this.exactSpill = LongArrays.EMPTY_ARRAY;
            this.subinventory = LongArrays.EMPTY_ARRAY;
            this.subinventory16 = null;
        }
    }

    @Override
    public long select(long rank) {
        int bitCount;
        int residual;
        assert (rank >= 0L);
        assert (rank < this.numOnes);
        int inventoryIndex = (int)(rank >>> this.log2OnesPerInventory);
        long inventoryRank = this.inventory[inventoryIndex];
        int subrank = (int)(rank & this.onesPerInventoryMask);
        if (subrank == 0) {
            return inventoryRank & Long.MAX_VALUE;
        }
        if (inventoryRank < 0L) {
            assert (this.onesPerSub64 > 1);
            return this.exactSpill[(int)(this.subinventory[inventoryIndex << this.log2LongwordsPerSubinventory] + (long)subrank)];
        }
        long index16 = ((long)inventoryIndex << this.log2LongwordsPerSubinventory + 2) + (long)(subrank >>> this.log2OnesPerSub16);
        long start = inventoryRank + (this.subinventory[(int)(index16 >>> 2)] >>> (int)((index16 & 3L) << 4) & 0xFFFFL);
        if (residual == 0) {
            return start;
        }
        long[][] bits = this.bits;
        long wordIndex = LongBigArrayBitVector.word((long)start);
        long word = BigArrays.get((long[][])bits, (long)wordIndex) & -1L << (int)start;
        for (residual = subrank & this.onesPerSub16Mask; residual >= (bitCount = Long.bitCount(word)); residual -= bitCount) {
            word = BigArrays.get((long[][])bits, (long)(++wordIndex));
        }
        return LongBigArrayBitVector.bits((long)wordIndex) + (long)Fast.select((long)word, (int)residual);
    }

    @Override
    public long[] select(long rank, long[] dest, int offset, int length) {
        long s;
        assert (rank >= 0L);
        assert (rank < this.numOnes);
        assert (offset >= 0);
        assert (dest != null);
        assert (offset < dest.length);
        assert (length >= 0);
        assert (offset + length <= dest.length);
        dest[offset] = s = this.select(rank);
        long curr = LongBigArrayBitVector.word((long)s);
        long[][] bits = this.bits;
        long window = BigArrays.get((long[][])bits, (long)curr) & -1L << (int)s;
        window &= window - 1L;
        for (int i = 1; i < length; ++i) {
            while (window == 0L) {
                window = BigArrays.get((long[][])bits, (long)(++curr));
            }
            dest[++offset] = LongBigArrayBitVector.bits((long)curr) + (long)Long.numberOfTrailingZeros(window);
            window &= window - 1L;
        }
        return dest;
    }

    @Override
    public long[] select(long rank, long[] dest) {
        assert (rank >= 0L);
        assert (rank < this.numOnes);
        assert (dest != null);
        assert (dest.length > 0);
        return this.select(rank, dest, 0, dest.length);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.subinventory16 = LongArrayBitVector.wrap((long[])this.subinventory).asLongBigList(16);
        this.bits = this.bitVector.bigBits();
    }

    @Override
    public long numBits() {
        return LongBigArrayBitVector.bits((long)this.inventory.length) + LongBigArrayBitVector.bits((long)this.subinventory.length) + LongBigArrayBitVector.bits((long)this.exactSpill.length);
    }

    public LongBigArrayBitVector bitVector() {
        return this.bitVector;
    }
}

