/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.stringparsers.ColorStringParser;
import java.awt.Color;
import junit.framework.TestCase;

public class TestColorStringParser
extends TestCase {
    public TestColorStringParser(String string) {
        super(string);
    }

    public void testIntegerRGB() {
        Color color = new Color(12, 34, 56);
        ColorStringParser colorStringParser = ColorStringParser.getParser();
        Color color2 = null;
        try {
            color2 = (Color)colorStringParser.parse("12,34,56");
        }
        catch (JSAPException jSAPException) {
            TestColorStringParser.fail((String)"12,34,56");
        }
        TestColorStringParser.assertEquals((Object)color, (Object)color2);
        try {
            color2 = (Color)colorStringParser.parse("12,34,56,");
            TestColorStringParser.fail((String)"12,34,56,");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
        try {
            color2 = (Color)colorStringParser.parse("12,3b,56");
            TestColorStringParser.fail((String)"12,3b,56");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public void testFloatRGB() {
        Color color = new Color(0.12f, 0.34f, 0.56f);
        ColorStringParser colorStringParser = ColorStringParser.getParser();
        Color color2 = null;
        try {
            color2 = (Color)colorStringParser.parse("0.12,.34,00.56");
        }
        catch (JSAPException jSAPException) {
            TestColorStringParser.fail((String)"0.12,.34,00.56");
        }
        TestColorStringParser.assertEquals((Object)color, (Object)color2);
        try {
            color2 = (Color)colorStringParser.parse("0.12,.34");
            TestColorStringParser.fail((String)"0.12,.34");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public void testHexRGB() {
        Color color = new Color(255, 255, 255);
        ColorStringParser colorStringParser = ColorStringParser.getParser();
        Color color2 = null;
        try {
            color2 = (Color)colorStringParser.parse("#fFFfFF");
        }
        catch (JSAPException jSAPException) {
            TestColorStringParser.fail((String)"#fFFfFF");
        }
        TestColorStringParser.assertEquals((Object)color, (Object)color2);
    }

    public void testByName() {
        Color color = new Color(255, 255, 255);
        ColorStringParser colorStringParser = ColorStringParser.getParser();
        Color color2 = null;
        try {
            color2 = (Color)colorStringParser.parse("white");
        }
        catch (JSAPException jSAPException) {
            TestColorStringParser.fail((String)"white");
        }
        TestColorStringParser.assertEquals((Object)color, (Object)color2);
        try {
            color2 = (Color)colorStringParser.parse("offwhite");
            TestColorStringParser.fail((String)"offwhite");
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }
}

