/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressStringParser
extends StringParser {
    private static final InetAddressStringParser INSTANCE = new InetAddressStringParser();

    public static InetAddressStringParser getParser() {
        return INSTANCE;
    }

    @Override
    public Object parse(String string) throws ParseException {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ParseException("Unknown host: " + string, unknownHostException);
        }
        return inetAddress;
    }
}

