/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.util.Arrays;
import java.util.StringTokenizer;

public class EnumeratedStringParser
extends StringParser {
    public static final char CONSTRUCTOR_VALUE_SEPARATOR = ';';
    private String[] validOptionValuesArray = null;
    private boolean isCaseSensitive;
    private boolean checkOptionChars;

    public static EnumeratedStringParser getParser(String string, boolean bl, boolean bl2) throws IllegalArgumentException {
        return new EnumeratedStringParser(string, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumeratedStringParser(String string, boolean bl, boolean bl2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("EnumeratedStringParser validOptions parameter is null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("EnumeratedStringParser validOptions parameter is empty");
        }
        this.isCaseSensitive = bl;
        this.checkOptionChars = bl2;
        if (string.indexOf(59) == -1) {
            this.validOptionValuesArray = new String[1];
            if (!this.isValidOptionName(string)) throw new IllegalArgumentException("Wrong character in EnumeratedStringParser option value: " + string + "\nsee EnumeratedStringParser javadoc for more information");
            this.validOptionValuesArray[0] = string;
            return;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this.validOptionValuesArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!this.isCaseSensitive) {
                    string2 = string2.toLowerCase();
                }
                if (!this.isValidOptionName(string2)) throw new IllegalArgumentException("Wrong character in EnumeratedStringParser option value: " + string2 + "\nsee EnumeratedStringParser javadoc for more information");
                this.validOptionValuesArray[n++] = string2;
            }
        }
    }

    public static EnumeratedStringParser getParser(String string, boolean bl) throws IllegalArgumentException {
        return new EnumeratedStringParser(string, bl, true);
    }

    public EnumeratedStringParser(String string, boolean bl) throws IllegalArgumentException {
        this(string, bl, true);
    }

    public static EnumeratedStringParser getParser(String string) throws IllegalArgumentException {
        return new EnumeratedStringParser(string, false, true);
    }

    public EnumeratedStringParser(String string) throws IllegalArgumentException {
        this(string, false, true);
    }

    @Override
    public Object parse(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        if (!this.isCaseSensitive) {
            string = string.toLowerCase();
        }
        if (!this.isValidOptionName(string)) {
            throw new ParseException("Wrong character in command line option value for enumerated option: '" + string + "'\nallowed are alphanumeric characters + '$' and '_' sign only", new IllegalArgumentException());
        }
        if (Arrays.asList(this.validOptionValuesArray).contains(string)) {
            return string;
        }
        throw new ParseException("Option has wrong value '" + string + "'; valid values are: " + Arrays.asList(this.validOptionValuesArray), new IllegalArgumentException());
    }

    protected boolean isValidOptionName(String string) {
        if (!this.checkOptionChars) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

