/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.defaultsources;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.defaultsources.PropertyDefaultSource;
import com.martiansoftware.jsap.stringparsers.StringStringParser;
import java.util.Properties;
import junit.framework.TestCase;

public class TestPropertyDefaultSource
extends TestCase {
    public void testUnexpectedProperties() {
        JSAP jSAP = new JSAP();
        try {
            jSAP.registerParameter(new FlaggedOption("testflagged", StringStringParser.getParser(), JSAP.NO_DEFAULT, false, 'f', "flagged"));
            jSAP.registerParameter(new UnflaggedOption("testunflagged", StringStringParser.getParser(), JSAP.NO_DEFAULT, false, false));
            jSAP.registerParameter(new Switch("testswitch", 's', "switch"));
        }
        catch (Throwable throwable) {
            TestPropertyDefaultSource.fail((String)throwable.getMessage());
        }
        Properties properties = new Properties();
        properties.setProperty("s", "true");
        properties.setProperty("flagged", "My Flagged Value");
        PropertyDefaultSource propertyDefaultSource = new PropertyDefaultSource(properties);
        jSAP.registerDefaultSource(propertyDefaultSource);
        JSAPResult jSAPResult = jSAP.parse("");
        TestPropertyDefaultSource.assertTrue((boolean)jSAPResult.success());
        TestPropertyDefaultSource.assertEquals((boolean)jSAPResult.getBoolean("testswitch"), (boolean)true);
        TestPropertyDefaultSource.assertEquals((String)jSAPResult.getString("testflagged"), (String)"My Flagged Value");
        properties.setProperty("unexpected", "jsap won't know what to do with this");
        jSAPResult = jSAP.parse("");
        TestPropertyDefaultSource.assertFalse((boolean)jSAPResult.success());
    }
}

