/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Switch;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUsageString
extends TestCase {
    public TestUsageString(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(TestUsageString.class);
    }

    public void testUsage1() {
        JSAP jSAP = new JSAP();
        FlaggedOption flaggedOption = new FlaggedOption("flaggedOption");
        flaggedOption.setShortFlag('f');
        flaggedOption.setLongFlag("flagged");
        flaggedOption.setRequired(true);
        try {
            jSAP.registerParameter(flaggedOption);
        }
        catch (JSAPException jSAPException) {
            TestUsageString.fail((String)"Unable to register opt1");
        }
        TestUsageString.assertEquals((String)("(-f|--flagged)" + JSAP.SYNTAX_SPACECHAR + "<flaggedOption>"), (String)jSAP.getUsage());
        jSAP.unregisterParameter(flaggedOption);
        flaggedOption.setRequired(false);
        try {
            jSAP.registerParameter(flaggedOption);
        }
        catch (JSAPException jSAPException) {
            TestUsageString.fail((String)"Unable to register opt1");
        }
        TestUsageString.assertEquals((String)("[(-f|--flagged)" + JSAP.SYNTAX_SPACECHAR + "<flaggedOption>]"), (String)jSAP.getUsage());
    }

    public void testUsage2() {
        JSAP jSAP = new JSAP();
        Switch switch_ = new Switch("testSwitch");
        switch_.setShortFlag('s');
        switch_.setLongFlag("switch");
        try {
            jSAP.registerParameter(switch_);
        }
        catch (JSAPException jSAPException) {
            TestUsageString.fail((String)"Unable to register sw");
        }
        TestUsageString.assertEquals((String)"[-s|--switch]", (String)jSAP.getUsage());
    }
}

