/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinuxUtils {
    private static final Logger logger = LoggerFactory.getLogger(LinuxUtils.class);
    private static final String DISTRIBUTION_NAME = LinuxUtils.resolveDistributionName();
    private static final boolean UNSHARE_AVAILABLE = LinuxUtils.unshareAvailable();

    private LinuxUtils() {
    }

    public static String getDistributionName() {
        return DISTRIBUTION_NAME;
    }

    public static boolean isUnshareAvailable() {
        return UNSHARE_AVAILABLE;
    }

    private static String resolveDistributionName() {
        if (!SystemUtils.IS_OS_LINUX) {
            return null;
        }
        try {
            String distributionName;
            Path target;
            try (InputStream source = LinuxUtils.class.getResourceAsStream("/sh/detect_linux_distribution.sh");){
                target = Files.createTempFile("detect_linux_distribution_", ".sh", new FileAttribute[0]);
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("sh", target.toFile().getAbsolutePath());
            Process process = builder.start();
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IOException("Execution of the script to detect the Linux distribution failed with error code: '" + process.exitValue() + "'");
            }
            try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                distributionName = outputReader.readLine();
            }
            if (StringUtils.isBlank((CharSequence)distributionName)) {
                logger.warn("It's not possible to detect the name of the Linux distribution, the detection script returned empty output");
                return null;
            }
            if (distributionName.startsWith("Debian")) {
                distributionName = "Debian";
            }
            if (distributionName.equals("openSUSE project")) {
                distributionName = "openSUSE";
            }
            return distributionName;
        }
        catch (Exception e) {
            logger.error("It's not possible to detect the name of the Linux distribution", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean unshareAvailable() {
        if (!SystemUtils.IS_OS_LINUX) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("getUid", new Class[0]);
            int uid = ((Number)method.invoke(instance, new Object[0])).intValue();
            if (uid != 0) {
                return false;
            }
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("unshare", "-U", "id", "-u");
            Process process = builder.start();
            process.waitFor();
            try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                if (process.exitValue() != 0) return false;
                if ("0".equals(outputReader.readLine())) return false;
                builder.command("unshare", "-U", "id", "-un");
                Process nameprocess = builder.start();
                nameprocess.waitFor();
                if (nameprocess.exitValue() != 0) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            return false;
        }
    }
}

