/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.support;

import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import java.util.Objects;
import org.springframework.util.Assert;

public final class ProviderDescriptor {
    private final String providerName;
    private final String databaseName;

    public static ProviderDescriptor of(String providerName, String databaseName) {
        return new ProviderDescriptor(providerName, databaseName);
    }

    private ProviderDescriptor(String providerName, String databaseName) {
        Assert.notNull((Object)databaseName, (String)"Database name must not be null");
        Assert.notNull((Object)providerName, (String)"Provider name must not be null");
        this.databaseName = databaseName.toLowerCase();
        this.providerName = providerName.toLowerCase();
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderDescriptor that = (ProviderDescriptor)o;
        return Objects.equals(this.providerName, that.providerName) && Objects.equals(this.databaseName, that.databaseName);
    }

    public int hashCode() {
        return Objects.hash(this.providerName, this.databaseName);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("providerName", this.providerName).add("databaseName", this.databaseName).toString();
    }
}

