/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.liquibase;

import io.zonky.test.db.context.DatabaseContext;
import io.zonky.test.db.liquibase.LiquibaseDatabasePreparer;
import io.zonky.test.db.liquibase.LiquibaseDescriptor;
import io.zonky.test.db.shaded.com.google.common.base.Preconditions;
import io.zonky.test.db.util.AopProxyUtils;
import liquibase.integration.spring.SpringLiquibase;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class LiquibaseDatabaseExtension
implements BeanPostProcessor,
Ordered {
    public int getOrder() {
        return -2147483647;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        SpringLiquibase liquibase;
        DatabaseContext context;
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        if (bean instanceof SpringLiquibase && (context = AopProxyUtils.getDatabaseContext((liquibase = (SpringLiquibase)bean).getDataSource())) != null) {
            if (bean instanceof Advised && !((Advised)bean).isFrozen()) {
                ((Advised)bean).addAdvisor(0, this.createAdvisor(liquibase));
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.addAdvisor(this.createAdvisor(liquibase));
            proxyFactory.setProxyTargetClass(true);
            return proxyFactory.getProxy();
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    protected Advisor createAdvisor(SpringLiquibase liquibase) {
        LiquibaseDatabaseExtensionInterceptor advice = new LiquibaseDatabaseExtensionInterceptor(liquibase);
        NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
        advisor.setMappedNames(new String[]{"afterPropertiesSet"});
        return advisor;
    }

    protected static class LiquibaseDatabaseExtensionInterceptor
    implements MethodInterceptor {
        protected final SpringLiquibase liquibase;

        protected LiquibaseDatabaseExtensionInterceptor(SpringLiquibase liquibase) {
            this.liquibase = liquibase;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (!"afterPropertiesSet".equals(invocation.getMethod().getName())) {
                return invocation.proceed();
            }
            LiquibaseDescriptor descriptor = LiquibaseDescriptor.from(this.liquibase);
            LiquibaseDatabasePreparer preparer = new LiquibaseDatabasePreparer(descriptor);
            DatabaseContext context = AopProxyUtils.getDatabaseContext(this.liquibase.getDataSource());
            Preconditions.checkState(context != null, "Data source context cannot be resolved");
            context.apply(preparer);
            return null;
        }
    }
}

