/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.shaded.com.google.common.collect;

import io.zonky.test.db.shaded.com.google.common.annotations.GwtCompatible;
import io.zonky.test.db.shaded.com.google.common.annotations.GwtIncompatible;
import io.zonky.test.db.shaded.com.google.common.annotations.J2ktIncompatible;
import io.zonky.test.db.shaded.com.google.common.collect.AbstractMapBasedMultiset;
import io.zonky.test.db.shaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import io.zonky.test.db.shaded.com.google.common.collect.Iterables;
import io.zonky.test.db.shaded.com.google.common.collect.Maps;
import io.zonky.test.db.shaded.com.google.common.collect.Multisets;
import io.zonky.test.db.shaded.com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return new HashMultiset<E>();
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private HashMultiset() {
        super(new HashMap());
    }

    private HashMultiset(int distinctElements) {
        super(Maps.newHashMapWithExpectedSize(distinctElements));
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(Maps.newHashMap());
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

