/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.postgres;

import com.cedarsoftware.util.DeepEquals;
import com.github.dockerjava.api.command.CreateContainerCmd;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseRequest;
import io.zonky.test.db.provider.DatabaseTemplate;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.TemplatableDatabaseProvider;
import io.zonky.test.db.provider.postgres.PostgreSQLContainerCustomizer;
import io.zonky.test.db.provider.postgres.PostgresEmbeddedDatabase;
import io.zonky.test.db.provider.support.BlockingDatabaseWrapper;
import io.zonky.test.db.provider.support.SimpleDatabaseTemplate;
import io.zonky.test.db.shaded.com.google.common.base.Throwables;
import io.zonky.test.db.shaded.com.google.common.cache.CacheBuilder;
import io.zonky.test.db.shaded.com.google.common.cache.CacheLoader;
import io.zonky.test.db.shaded.com.google.common.cache.LoadingCache;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import io.zonky.test.db.util.PropertyUtils;
import io.zonky.test.db.util.RandomStringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.ds.common.BaseDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public class DockerPostgresDatabaseProvider
implements TemplatableDatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(DockerPostgresDatabaseProvider.class);
    private static final String DEFAULT_POSTGRES_USERNAME = "postgres";
    private static final String DEFAULT_POSTGRES_PASSWORD = "docker";
    private static final LoadingCache<DatabaseConfig, DatabaseInstance> databases = CacheBuilder.newBuilder().build(new CacheLoader<DatabaseConfig, DatabaseInstance>(){

        @Override
        public DatabaseInstance load(DatabaseConfig config) {
            return new DatabaseInstance(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public DockerPostgresDatabaseProvider(Environment environment, ObjectProvider<List<PostgreSQLContainerCustomizer>> containerCustomizers) {
        String dockerImage = environment.getProperty("zonky.test.database.postgres.docker.image", "postgres:11-alpine");
        String tmpfsOptions = environment.getProperty("zonky.test.database.postgres.docker.tmpfs.options", "rw,noexec,nosuid");
        boolean tmpfsEnabled = (Boolean)environment.getProperty("zonky.test.database.postgres.docker.tmpfs.enabled", Boolean.TYPE, (Object)false);
        Map<String, String> initdbProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.initdb.properties");
        Map<String, String> configProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.server.properties");
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.client.properties");
        List customizers = Optional.ofNullable(containerCustomizers.getIfAvailable()).orElse(Collections.emptyList());
        this.databaseConfig = new DatabaseConfig(dockerImage, tmpfsOptions, tmpfsEnabled, initdbProperties, configProperties, customizers);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public DatabaseTemplate createTemplate(DatabaseRequest request) throws ProviderException {
        try {
            EmbeddedDatabase result = this.createDatabase(request);
            BaseDataSource dataSource = result.unwrap(BaseDataSource.class);
            return new SimpleDatabaseTemplate(dataSource.getDatabaseName(), result::close);
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database template", e);
        }
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabaseRequest request) throws ProviderException {
        try {
            DatabaseInstance instance = databases.get(this.databaseConfig);
            return instance.createDatabase(this.clientConfig, request);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
            throw new ProviderException("Unexpected error when preparing a database cluster", e.getCause());
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerPostgresDatabaseProvider that = (DockerPostgresDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final String dockerImage;
        private final String tmpfsOptions;
        private final boolean tmpfsEnabled;
        private final Map<String, String> initdbProperties;
        private final Map<String, String> configProperties;
        private final List<PostgreSQLContainerCustomizer> customizers;

        private DatabaseConfig(String dockerImage, String tmpfsOptions, boolean tmpfsEnabled, Map<String, String> initdbProperties, Map<String, String> configProperties, List<PostgreSQLContainerCustomizer> customizers) {
            this.dockerImage = dockerImage;
            this.tmpfsOptions = tmpfsOptions;
            this.tmpfsEnabled = tmpfsEnabled;
            this.initdbProperties = ImmutableMap.copyOf(initdbProperties);
            this.configProperties = ImmutableMap.copyOf(configProperties);
            this.customizers = customizers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return this.tmpfsEnabled == that.tmpfsEnabled && Objects.equals(this.dockerImage, that.dockerImage) && Objects.equals(this.tmpfsOptions, that.tmpfsOptions) && Objects.equals(this.initdbProperties, that.initdbProperties) && Objects.equals(this.configProperties, that.configProperties) && DeepEquals.deepEquals(this.customizers, that.customizers);
        }

        public int hashCode() {
            int result = Objects.hash(this.dockerImage, this.tmpfsOptions, this.tmpfsEnabled, this.initdbProperties, this.configProperties);
            result = 31 * result + DeepEquals.deepHashCode(this.customizers);
            return result;
        }
    }

    protected static class DatabaseInstance {
        private final PostgreSQLContainer container;
        private final Semaphore semaphore;

        private DatabaseInstance(DatabaseConfig config) {
            String initdbArgs = config.initdbProperties.entrySet().stream().map(e -> String.format("--%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
            HashMap<String, String> serverProperties = new HashMap<String, String>(config.configProperties);
            serverProperties.putIfAbsent("fsync", "off");
            serverProperties.putIfAbsent("full_page_writes", "off");
            serverProperties.putIfAbsent("max_connections", "300");
            String postgresArgs = serverProperties.entrySet().stream().map(e -> String.format("-c %s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
            this.container = this.createContainer(config.dockerImage, container -> {
                container.addEnv("POSTGRES_INITDB_ARGS", "--nosync " + initdbArgs);
                container.setCommand("postgres " + postgresArgs);
            });
            if (config.tmpfsEnabled) {
                Consumer<CreateContainerCmd> consumer = cmd -> cmd.getHostConfig().withTmpFs(ImmutableMap.of("/var/lib/postgresql/data", config.tmpfsOptions));
                this.container.withCreateContainerCmdModifier(consumer);
            }
            this.container.withUsername(DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME);
            this.container.withPassword(DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_PASSWORD);
            config.customizers.forEach(c -> c.customize(this.container));
            this.container.start();
            this.container.followOutput((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(DockerPostgresDatabaseProvider.class)));
            this.semaphore = new Semaphore(Integer.parseInt((String)serverProperties.get("max_connections")));
        }

        private PostgreSQLContainer createContainer(String dockerImage, final Consumer<PostgreSQLContainer> configAction) {
            if (ClassUtils.hasMethod(DockerImageName.class, (String)"asCompatibleSubstituteFor", (Class[])new Class[]{String.class})) {
                return new PostgreSQLContainer(DockerImageName.parse((String)dockerImage).asCompatibleSubstituteFor(DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME)){

                    protected void configure() {
                        super.configure();
                        configAction.accept(this);
                    }
                };
            }
            return new PostgreSQLContainer(dockerImage){

                protected void configure() {
                    super.configure();
                    configAction.accept(this);
                }
            };
        }

        public EmbeddedDatabase createDatabase(ClientConfig config, DatabaseRequest request) throws SQLException {
            DatabaseTemplate template = request.getTemplate();
            DatabasePreparer preparer = request.getPreparer();
            String databaseName = RandomStringUtils.randomAlphabetic(12).toLowerCase(Locale.ENGLISH);
            if (template != null) {
                this.executeStatement(config, String.format("CREATE DATABASE %s TEMPLATE %s OWNER %s ENCODING 'utf8'", databaseName, template.getTemplateName(), DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME));
            } else {
                this.executeStatement(config, String.format("CREATE DATABASE %s OWNER %s ENCODING 'utf8'", databaseName, DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME));
            }
            try {
                EmbeddedDatabase database = this.getDatabase(config, databaseName);
                if (preparer != null) {
                    preparer.prepare(database);
                }
                return database;
            }
            catch (Exception e) {
                this.dropDatabase(config, databaseName);
                throw e;
            }
        }

        private void dropDatabase(ClientConfig config, String dbName) {
            CompletableFuture.runAsync(() -> {
                block3: {
                    try {
                        this.executeStatement(config, String.format("DROP DATABASE IF EXISTS %s", dbName));
                    }
                    catch (SQLException e) {
                        if (!"55006".equals(e.getSQLState())) break block3;
                        if (logger.isTraceEnabled()) {
                            logger.warn("Unable to release '{}' database", (Object)dbName, (Object)e);
                        }
                        logger.warn("Unable to release '{}' database", (Object)dbName);
                    }
                }
            });
        }

        private void executeStatement(ClientConfig config, String ddlStatement) throws SQLException {
            EmbeddedDatabase dataSource = this.getDatabase(config, DockerPostgresDatabaseProvider.DEFAULT_POSTGRES_USERNAME);
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                stmt.execute();
            }
        }

        private EmbeddedDatabase getDatabase(ClientConfig config, String dbName) throws SQLException {
            PGSimpleDataSource dataSource = new PGSimpleDataSource();
            dataSource.setServerName(this.container.getContainerIpAddress());
            dataSource.setPortNumber(this.container.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()).intValue());
            dataSource.setDatabaseName(dbName);
            dataSource.setUser(this.container.getUsername());
            dataSource.setPassword(this.container.getPassword());
            for (Map.Entry entry : config.connectProperties.entrySet()) {
                dataSource.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return new BlockingDatabaseWrapper(new PostgresEmbeddedDatabase(dataSource, () -> this.dropDatabase(config, dbName)), this.semaphore);
        }
    }
}

