/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.mysql;

import com.mysql.cj.jdbc.MysqlDataSource;
import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import javax.sql.DataSource;
import org.springframework.util.StringUtils;

public class MySQLEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final MysqlDataSource dataSource;

    public MySQLEmbeddedDatabase(MysqlDataSource dataSource, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        String url = this.dataSource.getUrl() + String.format("?user=%s", this.dataSource.getUser());
        if (StringUtils.hasText((String)this.dataSource.getPassword())) {
            url = url + String.format("&password=%s", this.dataSource.getPassword());
        }
        return url;
    }
}

