/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.h2;

import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.h2.H2EmbeddedDatabase;
import io.zonky.test.db.util.ReflectionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.h2.Driver;
import org.h2.tools.Server;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.util.ClassUtils;

public class H2DatabaseProvider
implements DatabaseProvider {
    private static final Server server = H2DatabaseProvider.startServer();

    private static Server startServer() {
        try {
            Server server = Server.createTcpServer((String[])new String[]{"-tcp", "-tcpAllowOthers", "-tcpPort", "0"}).start();
            H2DatabaseProvider.registerShutdownHook(server);
            return server;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static void registerShutdownHook(Server server) {
        try {
            Class applicationType = ClassUtils.forName((String)"org.springframework.boot.SpringApplication", null);
            Object shutdownHandlers = ReflectionUtils.invokeStaticMethod(applicationType, "getShutdownHandlers", new Object[0]);
            Object[] objectArray = new Object[1];
            objectArray[0] = () -> ((Server)server).shutdown();
            ReflectionUtils.invokeMethod(shutdownHandlers, "add", objectArray);
        }
        catch (Throwable ex) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Server)server).shutdown()));
        }
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        String databaseName = UUID.randomUUID().toString();
        dataSource.setDriverClass(Driver.class);
        dataSource.setUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", databaseName));
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        H2EmbeddedDatabase database = new H2EmbeddedDatabase(server, (DataSource)dataSource, databaseName, () -> H2DatabaseProvider.shutdownDatabase((DataSource)dataSource, databaseName));
        try {
            if (preparer != null) {
                preparer.prepare(database);
            }
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
        return database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(H2DatabaseProvider.class);
    }

    private static void shutdownDatabase(DataSource dataSource, String dbName) {
        CompletableFuture.runAsync(() -> {
            try {
                H2DatabaseProvider.executeStatement(dataSource, "SHUTDOWN");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }

    private static void executeStatement(DataSource dataSource, String ddlStatement) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute(ddlStatement);
        }
    }
}

