/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import io.zonky.test.db.flyway.FlywayWrapper;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableSet;
import io.zonky.test.db.shaded.com.google.common.collect.Lists;
import io.zonky.test.db.shaded.com.google.common.collect.Maps;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.util.ReflectionUtils;

public class FlywayDescriptor {
    private static final Set<String> BASIC_FIELDS = ImmutableSet.of("locations", "schemaNames", "table", "sqlMigrationPrefix", "repeatableSqlMigrationPrefix", "sqlMigrationSeparator", new String[]{"sqlMigrationSuffixes", "ignoreMissingMigrations", "ignoreFutureMigrations", "validateOnMigrate"});
    private static final Set<String> EXCLUDED_FIELDS = ImmutableSet.of("cleanDisabled", "dbConnectionInfoPrinted", "classScanner", "pluginRegister");
    private static final Set<Class<?>> EXCLUDED_TYPES = ImmutableSet.of(DataSource.class, ClassLoader.class, OutputStream.class);
    private static final ReflectionUtils.FieldFilter OTHER_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !BASIC_FIELDS.contains(field.getName()) && !EXCLUDED_FIELDS.contains(field.getName()) && !EXCLUDED_TYPES.contains(field.getType());
    private static final ReflectionUtils.FieldFilter PLUGIN_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !EXCLUDED_TYPES.contains(field.getType());
    private final List<String> locations;
    private final List<String> schemas;
    private final String table;
    private final String sqlMigrationPrefix;
    private final String repeatableSqlMigrationPrefix;
    private final String sqlMigrationSeparator;
    private final List<String> sqlMigrationSuffixes;
    private final boolean ignoreMissingMigrations;
    private final boolean ignoreFutureMigrations;
    private final boolean validateOnMigrate;
    private final Map<Field, Object> otherFields;
    private final Map<Field, Object> envConfFields;
    private final Map<Class<?>, Map<Field, Object>> pluginsFields;

    private FlywayDescriptor(FlywayWrapper wrapper) {
        this.locations = ImmutableList.copyOf(wrapper.getLocations());
        this.schemas = ImmutableList.copyOf(wrapper.getSchemas());
        this.table = wrapper.getTable();
        this.sqlMigrationPrefix = wrapper.getSqlMigrationPrefix();
        this.repeatableSqlMigrationPrefix = wrapper.getRepeatableSqlMigrationPrefix();
        this.sqlMigrationSeparator = wrapper.getSqlMigrationSeparator();
        this.sqlMigrationSuffixes = ImmutableList.copyOf(wrapper.getSqlMigrationSuffixes());
        this.ignoreMissingMigrations = wrapper.isIgnoreMissingMigrations();
        this.ignoreFutureMigrations = wrapper.isIgnoreFutureMigrations();
        this.validateOnMigrate = wrapper.isValidateOnMigrate();
        this.otherFields = FlywayDescriptor.getFields(wrapper.getConfig(), OTHER_FIELDS);
        this.envConfFields = FlywayDescriptor.getFields(wrapper.getEnvConfig(), PLUGIN_FIELDS);
        HashMap pluginsFields = new HashMap();
        List<Object> plugins = wrapper.getConfigurationExtensions();
        for (Object plugin : plugins) {
            Map<Field, Object> pluginFields = FlywayDescriptor.getFields(plugin, PLUGIN_FIELDS);
            pluginsFields.put(plugin.getClass(), pluginFields);
        }
        this.pluginsFields = pluginsFields;
    }

    public static FlywayDescriptor from(FlywayWrapper wrapper) {
        return new FlywayDescriptor(wrapper);
    }

    public void applyTo(FlywayWrapper wrapper) {
        wrapper.setLocations(this.locations);
        wrapper.setSchemas(this.schemas);
        wrapper.setTable(this.table);
        wrapper.setSqlMigrationPrefix(this.sqlMigrationPrefix);
        wrapper.setRepeatableSqlMigrationPrefix(this.repeatableSqlMigrationPrefix);
        wrapper.setSqlMigrationSeparator(this.sqlMigrationSeparator);
        wrapper.setSqlMigrationSuffixes(this.sqlMigrationSuffixes);
        wrapper.setIgnoreMissingMigrations(this.ignoreMissingMigrations);
        wrapper.setIgnoreFutureMigrations(this.ignoreFutureMigrations);
        wrapper.setValidateOnMigrate(this.validateOnMigrate);
        FlywayDescriptor.setFields(wrapper.getConfig(), this.otherFields);
        FlywayDescriptor.setFields(wrapper.getEnvConfig(), this.envConfFields);
        List<Object> plugins = wrapper.getConfigurationExtensions();
        for (Object plugin : plugins) {
            Map<Field, Object> pluginFields = this.pluginsFields.get(plugin.getClass());
            FlywayDescriptor.setFields(plugin, pluginFields);
        }
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public String getTable() {
        return this.table;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayDescriptor that = (FlywayDescriptor)o;
        return this.ignoreMissingMigrations == that.ignoreMissingMigrations && this.ignoreFutureMigrations == that.ignoreFutureMigrations && this.validateOnMigrate == that.validateOnMigrate && Objects.equals(this.locations, that.locations) && Objects.equals(this.schemas, that.schemas) && Objects.equals(this.table, that.table) && Objects.equals(this.sqlMigrationPrefix, that.sqlMigrationPrefix) && Objects.equals(this.repeatableSqlMigrationPrefix, that.repeatableSqlMigrationPrefix) && Objects.equals(this.sqlMigrationSeparator, that.sqlMigrationSeparator) && Objects.equals(this.sqlMigrationSuffixes, that.sqlMigrationSuffixes) && Objects.equals(this.otherFields, that.otherFields) && Objects.equals(this.envConfFields, that.envConfFields) && Objects.equals(this.pluginsFields, that.pluginsFields);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.schemas, this.table, this.sqlMigrationPrefix, this.repeatableSqlMigrationPrefix, this.sqlMigrationSeparator, this.sqlMigrationSuffixes, this.ignoreMissingMigrations, this.ignoreFutureMigrations, this.validateOnMigrate, this.otherFields, this.envConfFields, this.pluginsFields);
    }

    private static void setCollection(Field field, Object target, Collection<?> value) {
        Collection collection = (Collection)ReflectionUtils.getField((Field)field, (Object)target);
        if (collection != null) {
            try {
                collection.clear();
                collection.addAll(value);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        ReflectionUtils.setField((Field)field, (Object)target, Lists.newArrayList(value));
    }

    private static void setMap(Field field, Object target, Map<?, ?> value) {
        Map map = (Map)ReflectionUtils.getField((Field)field, (Object)target);
        if (map != null) {
            try {
                map.clear();
                map.putAll(value);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        ReflectionUtils.setField((Field)field, (Object)target, Maps.newHashMap(value));
    }

    private static void setArray(Field field, Object config, List<?> value) {
        Class<?> componentType = field.getType().getComponentType();
        Object[] array = value.toArray((Object[])Array.newInstance(componentType, 0));
        ReflectionUtils.setField((Field)field, (Object)config, (Object)array);
    }

    private static Map<Field, Object> getFields(Object targetObject, ReflectionUtils.FieldFilter fieldFilter) {
        HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
        if (targetObject != null) {
            Class<?> objectClass = targetObject.getClass();
            ReflectionUtils.doWithFields(objectClass, field -> {
                ReflectionUtils.makeAccessible((Field)field);
                Cloneable value = ReflectionUtils.getField((Field)field, (Object)targetObject);
                if (value != null) {
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        value = Lists.newArrayList((Collection)((Object)value));
                    } else if (Map.class.isAssignableFrom(field.getType())) {
                        value = Maps.newHashMap((Map)((Object)value));
                    } else if (field.getType().isArray()) {
                        value = Lists.newArrayList((Object[])value);
                    }
                }
                fieldValues.put(field, value);
            }, (ReflectionUtils.FieldFilter)fieldFilter);
        }
        return fieldValues;
    }

    private static void setFields(Object targetObject, Map<Field, Object> fieldValues) {
        if (targetObject == null) {
            return;
        }
        fieldValues.forEach((field, value) -> {
            ReflectionUtils.makeAccessible((Field)field);
            if (value == null) {
                ReflectionUtils.setField((Field)field, (Object)targetObject, (Object)value);
            } else if (Collection.class.isAssignableFrom(field.getType())) {
                FlywayDescriptor.setCollection(field, targetObject, (Collection)value);
            } else if (Map.class.isAssignableFrom(field.getType())) {
                FlywayDescriptor.setMap(field, targetObject, (Map)value);
            } else if (field.getType().isArray()) {
                FlywayDescriptor.setArray(field, targetObject, (List)value);
            } else {
                ReflectionUtils.setField((Field)field, (Object)targetObject, (Object)value);
            }
        });
    }
}

