/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.flywaydb.core.Flyway;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StreamUtils;

public class FlywayClassUtils {
    private static final int flywayVersion = FlywayClassUtils.loadFlywayVersion();

    private FlywayClassUtils() {
    }

    private static int loadFlywayVersion() {
        try {
            ClassPathResource versionResource = new ClassPathResource("org/flywaydb/core/internal/version.txt", FlywayClassUtils.class.getClassLoader());
            if (versionResource.exists()) {
                return Integer.parseInt(StreamUtils.copyToString((InputStream)versionResource.getInputStream(), (Charset)StandardCharsets.UTF_8).replaceAll("^(\\d+)\\.\\d{2,}", "$1.9").replaceAll("^(\\d+)\\.(\\d).*", "$1$2"));
            }
            if (ClassUtils.hasMethod(Flyway.class, (String)"isPlaceholderReplacement", (Class[])new Class[0])) {
                return 32;
            }
            if (ClassUtils.hasMethod(Flyway.class, (String)"getBaselineVersion", (Class[])new Class[0])) {
                return 31;
            }
            return 30;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FlywayClassUtils.class).error("Unexpected error when resolving flyway version", (Throwable)e);
            return 0;
        }
    }

    public static int getFlywayVersion() {
        return flywayVersion;
    }
}

