/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.common;

import io.zonky.test.db.preparer.CompositeDatabasePreparer;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import io.zonky.test.db.shaded.com.google.common.base.Throwables;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.collect.Maps;
import io.zonky.test.db.util.RandomStringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureTask;

public class PrefetchingDatabaseProvider
implements DatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrefetchingDatabaseProvider.class);
    protected static final ThreadPoolTaskExecutor taskExecutor = new PriorityThreadPoolTaskExecutor();
    protected static final ConcurrentMap<PipelineKey, DatabasePipeline> pipelines = new ConcurrentHashMap<PipelineKey, DatabasePipeline>();
    protected static final AtomicLong databaseCount = new AtomicLong();
    protected final DatabaseProvider provider;
    protected final Config config;

    public PrefetchingDatabaseProvider(DatabaseProvider provider) {
        this(provider, Config.builder().build());
    }

    public PrefetchingDatabaseProvider(DatabaseProvider provider, Config config) {
        this.provider = provider;
        this.config = config;
        taskExecutor.setThreadNamePrefix(config.getThreadNamePrefix());
        taskExecutor.setCorePoolSize(config.getConcurrency());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefetchingDatabaseProvider that = (PrefetchingDatabaseProvider)o;
        return Objects.equals(this.provider, that.provider) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.config);
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.trace("Prefetching pipelines: {}", pipelines.values());
        databaseCount.decrementAndGet();
        PipelineKey key = new PipelineKey(this.provider, preparer);
        DatabasePipeline pipeline = pipelines.computeIfAbsent(key, k -> new DatabasePipeline());
        PreparedResult result = (PreparedResult)pipeline.results.poll();
        if (result != null) {
            this.prepareDatabase(key, Integer.MAX_VALUE);
        } else {
            boolean pipelineInitMode = pipeline.state.compareAndSet(DatabasePipeline.State.NEW, DatabasePipeline.State.INITIALIZING);
            Optional<PrefetchingTask> task = this.prepareExistingDatabase(key, Integer.MIN_VALUE);
            if (pipelineInitMode || !task.isPresent()) {
                this.prepareNewDatabase(key, Integer.MIN_VALUE);
            }
        }
        long invocationCount = pipeline.requests.incrementAndGet();
        long databasesCount = pipeline.tasks.size() + pipeline.results.size();
        if (result == null) {
            --databasesCount;
        }
        if (databasesCount < invocationCount - 1L && databasesCount < (long)this.config.getPipelineMaxCacheSize()) {
            this.prepareDatabase(key, -1);
        }
        this.reschedulePipeline(key);
        if (result == null) {
            try {
                result = pipeline.results.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ProviderException("Provider interrupted", e);
            }
        }
        EmbeddedDatabase database = result.get();
        logger.debug("Database has been successfully fetched in {} - pipelineKey={}", (Object)stopwatch, (Object)pipeline.key);
        return database;
    }

    protected PrefetchingTask prepareDatabase(PipelineKey key, int priority) {
        DatabasePipeline pipeline = (DatabasePipeline)pipelines.get(key);
        if (pipeline.state.get() != DatabasePipeline.State.INITIALIZED) {
            return this.prepareExistingDatabase(key, priority).orElseGet(() -> this.prepareNewDatabase(key, priority));
        }
        return this.prepareNewDatabase(key, priority);
    }

    protected PrefetchingTask prepareNewDatabase(PipelineKey key, int priority) {
        databaseCount.incrementAndGet();
        Map.Entry databaseToRemove = this.findDatabaseToRemove().orElse(null);
        if (databaseToRemove != null) {
            databaseCount.decrementAndGet();
            if (((PipelineKey)databaseToRemove.getKey()).equals(key)) {
                return this.executeTask(key, PrefetchingTask.withDatabase((EmbeddedDatabase)databaseToRemove.getValue(), priority));
            }
            ((EmbeddedDatabase)databaseToRemove.getValue()).close();
            DatabasePipeline pipeline = (DatabasePipeline)pipelines.get(databaseToRemove.getKey());
            logger.trace("Prepared database has been cleaned: {}", (Object)pipeline.key);
        }
        return this.executeTask(key, PrefetchingTask.forPreparer(key.provider, key.preparer, priority));
    }

    protected Optional<PrefetchingTask> prepareExistingDatabase(PipelineKey key, int priority) {
        CompositeDatabasePreparer compositePreparer = key.preparer instanceof CompositeDatabasePreparer ? (CompositeDatabasePreparer)key.preparer : new CompositeDatabasePreparer(ImmutableList.of(key.preparer));
        List<DatabasePreparer> preparers = compositePreparer.getPreparers();
        for (int i = preparers.size() - 1; i > 0; --i) {
            CompositeDatabasePreparer pipelinePreparer = new CompositeDatabasePreparer(preparers.subList(0, i));
            PipelineKey pipelineKey = new PipelineKey(this.provider, pipelinePreparer);
            DatabasePipeline existingPipeline = (DatabasePipeline)pipelines.get(pipelineKey);
            if (existingPipeline == null) continue;
            if (key.preparer.estimatedDuration() - pipelinePreparer.estimatedDuration() > 600L) {
                return Optional.empty();
            }
            PreparedResult result = (PreparedResult)existingPipeline.results.poll();
            if (result == null) continue;
            CompositeDatabasePreparer complementaryPreparer = new CompositeDatabasePreparer(preparers.subList(i, preparers.size()));
            logger.trace("Preparing existing database from {} pipeline by using the complementary preparer {}", (Object)existingPipeline.key, (Object)complementaryPreparer);
            PrefetchingTask task = this.executeTask(key, PrefetchingTask.withDatabase(result.get(), complementaryPreparer, priority));
            this.prepareDatabase(pipelineKey, Integer.MAX_VALUE);
            this.reschedulePipeline(pipelineKey);
            return Optional.of(task);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reschedulePipeline(PipelineKey key) {
        DatabasePipeline pipeline = (DatabasePipeline)pipelines.get(key);
        Set<PrefetchingTask> set = pipeline.tasks;
        synchronized (set) {
            long invocationCount = pipeline.requests.get();
            List cancelledTasks = pipeline.tasks.stream().filter(t -> t.priority > Integer.MIN_VALUE).filter(t -> t.cancel(false)).collect(Collectors.toList());
            for (int i = 0; i < cancelledTasks.size(); ++i) {
                int priority = -1 * (int)(invocationCount / (long)cancelledTasks.size() * (long)(i + 1));
                this.executeTask(key, PrefetchingTask.fromTask((PrefetchingTask)cancelledTasks.get(i), priority));
            }
        }
    }

    protected PrefetchingTask executeTask(PipelineKey key, final PrefetchingTask task) {
        final DatabasePipeline pipeline = (DatabasePipeline)pipelines.get(key);
        task.addCallback((ListenableFutureCallback)new ListenableFutureCallback<EmbeddedDatabase>(){

            public void onSuccess(EmbeddedDatabase result) {
                if (task.type == PrefetchingTask.TaskType.NEW_DATABASE) {
                    pipeline.state.set(DatabasePipeline.State.INITIALIZED);
                }
                pipeline.tasks.remove(task);
                pipeline.results.offer(PreparedResult.success(result));
            }

            public void onFailure(Throwable error) {
                pipeline.tasks.remove(task);
                if (!(error instanceof CancellationException)) {
                    pipeline.results.offer(PreparedResult.failure(error));
                }
            }
        });
        pipeline.tasks.add(task);
        taskExecutor.execute((Runnable)((Object)task));
        return task;
    }

    protected Optional<Map.Entry<PipelineKey, EmbeddedDatabase>> findDatabaseToRemove() {
        while (databaseCount.get() > (long)this.config.getMaxPreparedDatabases()) {
            PreparedResult result;
            long timestampThreshold = System.currentTimeMillis() - 10000L;
            PipelineKey key = pipelines.entrySet().stream().map(e -> Maps.immutableEntry(e.getKey(), ((DatabasePipeline)e.getValue()).results.peek())).filter(e -> e.getValue() != null && ((PreparedResult)e.getValue()).getTimestamp() < timestampThreshold).min(Comparator.comparing(e -> ((PreparedResult)e.getValue()).getTimestamp())).map(Map.Entry::getKey).orElse(null);
            if (key == null) {
                return Optional.empty();
            }
            DatabasePipeline pipeline = (DatabasePipeline)pipelines.get(key);
            if (pipeline == null || (result = (PreparedResult)pipeline.results.poll()) == null) continue;
            if (result.hasResult()) {
                return Optional.of(Maps.immutableEntry(key, result.get()));
            }
            databaseCount.decrementAndGet();
        }
        return Optional.empty();
    }

    static {
        taskExecutor.setThreadNamePrefix("prefetching-");
        taskExecutor.setAllowCoreThreadTimeOut(true);
        taskExecutor.setKeepAliveSeconds(60);
        taskExecutor.setCorePoolSize(1);
        taskExecutor.initialize();
    }

    public static class Config {
        private final String threadNamePrefix;
        private final int concurrency;
        private final int pipelineMaxCacheSize;
        private final int maxPreparedDatabases;

        private Config(Builder builder) {
            this.threadNamePrefix = builder.threadNamePrefix;
            this.concurrency = builder.concurrency;
            this.pipelineMaxCacheSize = builder.pipelineMaxCacheSize;
            this.maxPreparedDatabases = builder.maxPreparedDatabases;
        }

        public String getThreadNamePrefix() {
            return this.threadNamePrefix;
        }

        public int getConcurrency() {
            return this.concurrency;
        }

        public int getPipelineMaxCacheSize() {
            return this.pipelineMaxCacheSize;
        }

        public int getMaxPreparedDatabases() {
            return this.maxPreparedDatabases;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return this.pipelineMaxCacheSize == config.pipelineMaxCacheSize;
        }

        public int hashCode() {
            return Objects.hash(this.pipelineMaxCacheSize);
        }

        public static class Builder {
            private String threadNamePrefix = "prefetching-";
            private int concurrency = 3;
            private int pipelineMaxCacheSize = 5;
            private int maxPreparedDatabases = 15;

            private Builder() {
            }

            public Builder withThreadNamePrefix(String threadNamePrefix) {
                this.threadNamePrefix = threadNamePrefix;
                return this;
            }

            public Builder withConcurrency(int concurrency) {
                this.concurrency = concurrency;
                return this;
            }

            public Builder withPipelineMaxCacheSize(int pipelineMaxCacheSize) {
                this.pipelineMaxCacheSize = pipelineMaxCacheSize;
                return this;
            }

            public Builder withMaxPreparedDatabases(int maxPreparedDatabases) {
                this.maxPreparedDatabases = maxPreparedDatabases;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }

    protected static class PrefetchingTask
    extends ListenableFutureTask<EmbeddedDatabase>
    implements Comparable<PrefetchingTask> {
        private final AtomicBoolean executed = new AtomicBoolean(false);
        public final Callable<EmbeddedDatabase> action;
        public final TaskType type;
        public final int priority;

        public static PrefetchingTask forPreparer(DatabaseProvider provider, DatabasePreparer preparer, int priority) {
            return new PrefetchingTask(priority, TaskType.NEW_DATABASE, () -> provider.createDatabase(preparer));
        }

        public static PrefetchingTask withDatabase(EmbeddedDatabase database, DatabasePreparer preparer, int priority) {
            return new PrefetchingTask(priority, TaskType.EXISTING_DATABASE, () -> {
                preparer.prepare(database);
                return database;
            });
        }

        public static PrefetchingTask withDatabase(EmbeddedDatabase database, int priority) {
            return new PrefetchingTask(priority, TaskType.EXISTING_DATABASE, () -> database);
        }

        public static PrefetchingTask fromTask(PrefetchingTask task, int priority) {
            return new PrefetchingTask(priority, task.type, task.action);
        }

        private PrefetchingTask(int priority, TaskType type, Callable<EmbeddedDatabase> action) {
            super(action);
            this.action = action;
            this.type = type;
            this.priority = priority;
        }

        public void run() {
            if (this.executed.compareAndSet(false, true)) {
                super.run();
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning || this.executed.compareAndSet(false, true)) {
                return super.cancel(mayInterruptIfRunning);
            }
            return false;
        }

        @Override
        public int compareTo(PrefetchingTask task) {
            return Integer.compare(this.priority, task.priority);
        }

        protected static enum TaskType {
            NEW_DATABASE,
            EXISTING_DATABASE;

        }
    }

    protected static class PriorityThreadPoolTaskExecutor
    extends ThreadPoolTaskExecutor {
        protected PriorityThreadPoolTaskExecutor() {
        }

        protected BlockingQueue<Runnable> createQueue(int queueCapacity) {
            return new PriorityBlockingQueue<Runnable>();
        }
    }

    protected static class PreparedResult {
        private final long timestamp = System.currentTimeMillis();
        private final EmbeddedDatabase result;
        private final Throwable error;

        public static PreparedResult success(EmbeddedDatabase result) {
            return new PreparedResult(result, null);
        }

        public static PreparedResult failure(Throwable error) {
            return new PreparedResult(null, error);
        }

        protected PreparedResult(EmbeddedDatabase result, Throwable error) {
            this.result = result;
            this.error = error;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean hasResult() {
            return this.result != null;
        }

        public EmbeddedDatabase get() throws ProviderException {
            if (this.result != null) {
                return this.result;
            }
            Throwables.throwIfInstanceOf(this.error, ProviderException.class);
            throw new ProviderException("Unexpected error when prefetching a database", this.error);
        }
    }

    protected static class DatabasePipeline {
        public final String key = RandomStringUtils.randomAlphabetic(8);
        public final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
        public final AtomicLong requests = new AtomicLong();
        public final Set<PrefetchingTask> tasks = Collections.newSetFromMap(new ConcurrentHashMap());
        public final BlockingQueue<PreparedResult> results = new LinkedBlockingQueue<PreparedResult>();

        protected DatabasePipeline() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("pipelineKey", this.key).add("pipelineState", (Object)this.state.get()).add("totalRequests", this.requests.get()).add("prefetchingQueue", this.tasks.size()).add("preparedResults", this.results.size()).toString();
        }

        protected static enum State {
            NEW,
            INITIALIZING,
            INITIALIZED;

        }
    }

    protected static class PipelineKey {
        public final DatabaseProvider provider;
        public final DatabasePreparer preparer;

        protected PipelineKey(DatabaseProvider provider, DatabasePreparer preparer) {
            this.provider = provider;
            this.preparer = preparer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineKey that = (PipelineKey)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.preparer, that.preparer);
        }

        public int hashCode() {
            return Objects.hash(this.provider, this.preparer);
        }
    }
}

